/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd.image.data;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataListener;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public interface RawImageDataProvider {
    public static final List<InnerRawImageDataListener> LISTENERS = new ArrayList<InnerRawImageDataListener>();

    public RawImageData getRawImageData(ReadOutParameters var1);

    public static void addRawImageDataListener(RawImageDataListener listener, RawImageDataProvider provider) {
        LISTENERS.add(new InnerRawImageDataListener(listener, provider));
    }

    public static void removeRawImageDataListener(RawImageDataListener listener) {
        ArrayList<InnerRawImageDataListener> toRemove = new ArrayList<InnerRawImageDataListener>();
        for (InnerRawImageDataListener inner : LISTENERS) {
            if (inner.getListener() != listener) continue;
            toRemove.add(inner);
        }
        for (InnerRawImageDataListener inner : toRemove) {
            LISTENERS.remove(inner);
        }
    }

    public static void notifyRawImageDataListeners(RawImageDataProvider dataProvider) {
        for (InnerRawImageDataListener l : LISTENERS) {
            if (l.getProvider() != dataProvider) continue;
            l.getListener().rawImageDataAvailable(dataProvider);
        }
    }

    public static class InnerRawImageDataListener {
        final RawImageDataListener listener;
        final RawImageDataProvider provider;

        InnerRawImageDataListener(RawImageDataListener listener, RawImageDataProvider provider) {
            this.listener = listener;
            this.provider = provider;
        }

        RawImageDataListener getListener() {
            return this.listener;
        }

        RawImageDataProvider getProvider() {
            return this.provider;
        }
    }
}

