/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.util.AsciiFuncs;

public final class ByteFormatter {
    public static final String NOT_A_NUMBER = "NaN";
    public static final String INFINITY = "Infinity";
    public static final String NEGATIVE_INFINITY = "-Infinity";
    private static final double DEFAULT_SIMPLE_MAX = 1000000.0;
    private static final double DEFAULT_SIMPLE_MIN = 0.001;
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final long DOUBLE_EXPONENT_BIT_MASK = 0x7FF0000000000000L;
    private static final int DOUBLE_EXPONENT_EXCESS = 52;
    private static final long DOUBLE_EXPONENT_NORMALIZE_BIT = 0x10000000000000L;
    private static final int DOUBLE_MIN_EXPONENT = -1023;
    private static final int DOUBLE_SHIFT_BASE = 17;
    private static final int DOUBLE_SHIFT_LIMIT = 200;
    private static final long DOUBLE_VALUE_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final int FLOAT_EXPONENT_BIT_MASK = 2139095040;
    private static final int FLOAT_EXPONENT_EXCESS = 23;
    private static final int FLOAT_EXPONENT_NORMALIZE_BIT = 0x800000;
    private static final int FLOAT_MIN_EXPONENT = -127;
    private static final int FLOAT_SHIFT_BASE = 8;
    private static final int FLOAT_SHIFT_LIMIT = 30;
    private static final int FLOAT_VALUE_BIT_MASK = 0x7FFFFF;
    private static final double I_LOG_10 = 1.0 / Math.log(10.0);
    private static final long LONG_TO_INT_MODULO = 1000000000L;
    private static final int MAX_LONG_LENGTH = 19;
    private static final int MAXIMUM_SINGLE_DIGIT_INTEGER = 9;
    private static final int MAXIMUM_TWO_DIGIT_INTEGER = 99;
    private static final int TEMP_BUFFER_SIZE = 32;
    private static final int NUMBER_BASE = 10;
    private static final double[] NUMBER_BASE_POWERS;
    private static final byte TRUNCATION_FILL = 42;
    private static final int ZERO_POW;
    private final byte[] tbuf1 = new byte[32];
    private final byte[] tbuf2 = new byte[32];

    private int combineReal(double val, byte[] buf, int off, int len, byte[] mant, int lmant, int shift) {
        int maxSize;
        int minSize;
        double pos = Math.abs(val);
        boolean simple = false;
        if (pos >= 0.001 && pos <= 1000000.0) {
            simple = true;
        }
        int exp = lmant - shift - 1;
        int lexp = 0;
        if (!simple) {
            lexp = this.format(exp, this.tbuf2, 0, 32);
            minSize = lexp + 2;
            maxSize = lexp + lmant + 2;
        } else if (exp >= 0) {
            int i;
            minSize = exp + 1;
            for (i = 0; i < lmant && i <= exp && mant[i] == 57; ++i) {
            }
            if (i > exp && i < lmant && mant[i] >= 53) {
                ++minSize;
            }
            if ((maxSize = lmant + 1) <= minSize) {
                maxSize = minSize + 1;
            }
        } else {
            minSize = 2;
            maxSize = 1 + Math.abs(exp) + lmant;
        }
        if (val < 0.0) {
            ++minSize;
            ++maxSize;
        }
        if (minSize > len || minSize > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        if (val < 0.0) {
            buf[off] = 45;
            ++off;
            --len;
        }
        if (simple) {
            return Math.abs(this.mantissa(mant, lmant, exp, simple, buf, off, len));
        }
        if ((off = this.mantissa(mant, lmant, 0, simple, buf, off, len - lexp - 1)) < 0) {
            off = -off;
            len -= off;
            if (exp == 9 || exp == 99) {
                if (off + len == minSize) {
                    this.truncationFiller(buf, off, len);
                    return off + len;
                }
                --off;
            }
            lexp = this.format(++exp, this.tbuf2, 0, 32);
        }
        buf[off] = 69;
        System.arraycopy(this.tbuf2, 0, buf, ++off, lexp);
        return off + lexp;
    }

    public int format(boolean val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(boolean val, byte[] array, int off, int len) {
        if (len > 0) {
            array[off] = val ? 84 : 70;
            ++off;
        }
        return off;
    }

    public int format(double val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(double val, byte[] buf, int off, int len) {
        double scale;
        double pos = Math.abs(val);
        if (pos == 0.0) {
            return this.format("0.0", buf, off, len);
        }
        if (Double.isNaN(val)) {
            return this.format(NOT_A_NUMBER, buf, off, len);
        }
        if (Double.isInfinite(val)) {
            if (val > 0.0) {
                return this.format(INFINITY, buf, off, len);
            }
            return this.format(NEGATIVE_INFINITY, buf, off, len);
        }
        int power = (int)(Math.log(pos) * I_LOG_10);
        int shift = 17 - power;
        double scale2 = 1.0;
        if (shift < 200) {
            scale = NUMBER_BASE_POWERS[shift + ZERO_POW];
        } else {
            scale2 = NUMBER_BASE_POWERS[200 + ZERO_POW];
            scale = NUMBER_BASE_POWERS[shift - 200 + ZERO_POW];
        }
        pos = pos * scale * scale2;
        long bits = Double.doubleToLongBits(pos);
        int exp = (int)(((bits & 0x7FF0000000000000L) >> 52) + -1023L);
        long numb = bits & 0xFFFFFFFFFFFFFL;
        if (exp > -1023) {
            numb |= 0x10000000000000L;
        } else {
            ++exp;
        }
        int ndig = this.format(numb <<= exp - 52, this.tbuf1, 0, 32);
        return this.combineReal(val, buf, off, len, this.tbuf1, ndig, shift);
    }

    public int format(float val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(float val, byte[] buf, int off, int len) {
        float scale;
        float pos = Math.abs(val);
        if ((double)pos == 0.0) {
            return this.format("0.0", buf, off, len);
        }
        if (Float.isNaN(val)) {
            return this.format(NOT_A_NUMBER, buf, off, len);
        }
        if (Float.isInfinite(val)) {
            if (val > 0.0f) {
                return this.format(INFINITY, buf, off, len);
            }
            return this.format(NEGATIVE_INFINITY, buf, off, len);
        }
        int power = (int)Math.floor(Math.log(pos) * I_LOG_10);
        int shift = 8 - power;
        float scale2 = 1.0f;
        if (shift < 30) {
            scale = (float)NUMBER_BASE_POWERS[shift + ZERO_POW];
        } else {
            scale2 = (float)NUMBER_BASE_POWERS[30 + ZERO_POW];
            scale = (float)NUMBER_BASE_POWERS[shift - 30 + ZERO_POW];
        }
        pos = pos * scale * scale2;
        int bits = Float.floatToIntBits(pos);
        int exp = ((bits & 0x7F800000) >> 23) + -127;
        int numb = bits & 0x7FFFFF;
        if (exp > -127) {
            numb |= 0x800000;
        } else {
            ++exp;
        }
        int ndig = this.format(numb <<= exp - 23, this.tbuf1, 0, 32);
        return this.combineReal(val, buf, off, len, this.tbuf1, ndig, shift);
    }

    public int format(int val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(int val, byte[] buf, int off, int len) {
        if (val == Integer.MIN_VALUE) {
            if (len > 10) {
                return this.format("-2147483648", buf, off, len);
            }
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        int pos = Math.abs(val);
        int ndig = 1;
        for (int dmax = 10; ndig < 10 && pos >= dmax; ++ndig, dmax *= 10) {
        }
        if (val < 0) {
            ++ndig;
        }
        if (ndig > len || ndig > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        int xoff = (off += ndig) - 1;
        do {
            buf[xoff] = DIGITS[pos % 10];
            --xoff;
        } while ((pos /= 10) > 0);
        if (val < 0) {
            buf[xoff] = 45;
        }
        return off;
    }

    public int format(long val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(long val, byte[] buf, int off, int len) {
        boolean last;
        if (val == Long.MIN_VALUE) {
            if (len > 19) {
                return this.format("-9223372036854775808", buf, off, len);
            }
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        long pos = Math.abs(val);
        int ndig = 1;
        for (long dmax = 10L; ndig < 19 && pos >= dmax; ++ndig, dmax *= 10L) {
        }
        if (val < 0L) {
            ++ndig;
        }
        if (ndig > len || ndig > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        int xoff = (off += ndig) - 1;
        buf[xoff] = 48;
        boolean bl = last = pos == 0L;
        block1: while (!last) {
            int giga = (int)(pos % 1000000000L);
            last = (pos /= 1000000000L) == 0L;
            for (int i = 0; i < 9; ++i) {
                buf[xoff] = DIGITS[giga % 10];
                --xoff;
                if (last && (giga /= 10) == 0) continue block1;
            }
        }
        if (val < 0L) {
            buf[xoff] = 45;
        }
        return off;
    }

    public int format(String val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(String val, byte[] array, int off, int len) {
        if (val == null) {
            for (int i = 0; i < len; ++i) {
                array[off + i] = 32;
            }
            return off + len;
        }
        int slen = val.length();
        if (slen > len || slen > array.length - off) {
            val = val.substring(0, len);
            slen = len;
        }
        System.arraycopy(AsciiFuncs.getBytes(val), 0, array, off, slen);
        return off + slen;
    }

    private int mantissa(byte[] mant, int lmant, int exp, boolean simple, byte[] buf, int off, int len) {
        int i;
        int off0 = off;
        int pos = 0;
        if (exp < 0) {
            buf[off] = 48;
            ++off;
            if (--len > 0) {
                buf[off] = 46;
                ++off;
                --len;
            }
            int cexp = exp;
            while (cexp < -1 && len > 0) {
                buf[off] = 48;
                ++cexp;
                ++off;
                --len;
            }
        } else {
            while (exp >= 0 && pos < lmant) {
                buf[off] = mant[pos];
                ++off;
                ++pos;
                --len;
                --exp;
            }
            for (i = 0; i <= exp; ++i) {
                buf[off] = 48;
                ++off;
                --len;
            }
            if (len > 0) {
                buf[off] = 46;
                --len;
                ++off;
            }
        }
        while (len > 0 && pos < lmant) {
            buf[off] = mant[pos];
            ++off;
            --exp;
            --len;
            ++pos;
        }
        if (pos < lmant && mant[pos] >= 53) {
            for (i = off - 1; i >= off0; --i) {
                if (buf[i] == 46 || buf[i] == 45) continue;
                if (buf[i] == 57) {
                    buf[i] = 48;
                    continue;
                }
                int n = i;
                buf[n] = (byte)(buf[n] + 1);
                break;
            }
            if (i < off0) {
                buf[off0] = 49;
                boolean foundDecimal = false;
                for (i = off0 + 1; i < off; ++i) {
                    if (buf[i] != 46) continue;
                    foundDecimal = true;
                    if (!simple) break;
                    buf[i] = 48;
                    if (++i >= off) break;
                    buf[i] = 46;
                    break;
                }
                if (simple && !foundDecimal) {
                    buf[off + 1] = 48;
                    ++off;
                }
                off = -off;
            }
        }
        return off;
    }

    private void truncationFiller(byte[] buffer, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            buffer[i] = 42;
        }
    }

    static {
        int min = (int)Math.floor((int)(Math.log(Double.MIN_VALUE) * I_LOG_10));
        int max = (int)Math.floor((int)(Math.log(Double.MAX_VALUE) * I_LOG_10));
        NUMBER_BASE_POWERS = new double[++max - min + 1];
        for (int i = 0; i < NUMBER_BASE_POWERS.length; ++i) {
            ByteFormatter.NUMBER_BASE_POWERS[i] = Math.pow(10.0, i + min);
        }
        ZERO_POW = -min;
    }
}

