/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.startup.SubsystemBootFromBus;
import org.lsst.ccs.startup.SubsystemBootFromStream;

public class SubsystemBoot {
    static String descriptionName;
    static String configurationName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        String choice = System.getProperty("lsst.bootArgsStyle", "4J");
        if ("4J".equals(choice)) {
            SubsystemBoot.parseArgs4j(args);
        } else if ("position".equals(choice)) {
            SubsystemBoot.parseArgs(args);
        } else if ("colon".equals(choice)) {
            SubsystemBoot.parseArgsColon(args);
        } else {
            System.err.println("property lsst.bootArgsStyle : " + choice + " not supported!");
        }
        if (descriptionName == null) {
            if (configurationName != null) throw new IllegalArgumentException("no description specification");
            SubsystemBootFromBus.main(new String[0]);
            return;
        } else if (descriptionName.contains(".")) {
            if (configurationName != null) {
                if (!configurationName.contains(".")) {
                    throw new IllegalArgumentException("incoherent specification description is a file and configuration is not one!");
                }
                SubsystemBootFromStream.main(new String[]{descriptionName, configurationName});
                return;
            } else {
                SubsystemBootFromStream.main(new String[]{descriptionName});
            }
            return;
        } else if (configurationName != null) {
            if (configurationName.contains(".")) {
                throw new UnsupportedOperationException("loading description from bus and configuration locally");
            }
            String[] names = configurationName.split("_");
            switch (names.length) {
                case 1: {
                    SubsystemBootFromBus.main(new String[]{descriptionName, configurationName});
                    return;
                }
                case 2: {
                    SubsystemBootFromBus.main(new String[]{descriptionName, names[0], names[1]});
                    return;
                }
                default: {
                    throw new IllegalArgumentException("too many underscores in " + configurationName);
                }
            }
        } else {
            SubsystemBootFromBus.main(new String[]{descriptionName});
        }
    }

    static void parseArgs(String[] args) {
        switch (args.length) {
            case 2: {
                configurationName = args[1];
            }
            case 1: {
                String arg1 = args[0];
                if ("?".equals(arg1) || "help".equals(arg1)) {
                    SubsystemBoot.usage();
                }
                descriptionName = arg1;
            }
        }
    }

    static void parseArgsColon(String[] args) {
        for (int ix = 0; ix < args.length; ++ix) {
            String arg = args[ix];
            if (arg.startsWith("description:")) {
                descriptionName = arg.replace("description:", "");
                continue;
            }
            if (arg.startsWith("configuration:")) {
                configurationName = arg.replace("configuration:", "");
                continue;
            }
            if (arg.startsWith("?") || arg.startsWith("help:")) {
                SubsystemBoot.usageColon();
                continue;
            }
            System.err.println("Oops! (is there some unneeded space?)");
            SubsystemBoot.usageColon();
        }
    }

    static void parseArgs4j(String[] args) {
        ArgBean bean = new ArgBean();
        CmdLineParser parser = new CmdLineParser((Object)bean);
        try {
            parser.parseArgument(args);
            descriptionName = bean.descriptionDesc;
            configurationName = bean.configDesc;
        }
        catch (CmdLineException e) {
            System.err.println("" + (Object)((Object)e));
            SubsystemBoot.usage4j();
        }
    }

    static void usageColon() {
        System.out.println("usages arguments:\n <no args> (boots from bus using the MacAddress)\n description:subsystemName (boots from bus requesting the subsystem)\n description:subsystemName configuration:configurationName (boots from bus : configurationName can be configurationName_tagName\n description:descriptionFile (boots from description file or resource)\n description:descriptionFile configuration:configurationPropertiesFiles (boots from these files or resources");
        System.exit(0);
    }

    static void usage4j() {
        System.out.println("usage arguments:\n <no args> (boots from bus using the MacAddress)\n --description:subsystemName (boots from bus requesting the subsystem)\n --description:subsystemName --configuration:configurationName (boots from bus : configurationName can be configurationName_tagName\n --description:descriptionFile (boots from description file or resource)\n --description:descriptionFile --configuration:configurationPropertiesFiles (boots from these files or resources");
        System.exit(0);
    }

    static void usage() {
        System.out.println("usage arguments:\n <no args> (boots from bus using the MacAddress)\n subsystemName (boots from bus requesting the subsystem)\n subsystemName configurationName (boots from bus : configurationName can be configurationName_tagName\n descriptionFile (boots from description file or resource)\n descriptionFile configurationPropertiesFiles (boots from these files or resources");
        System.exit(0);
    }

    static class ArgBean {
        @Option(name="--description", usage="subsystemName of subsystem descriptin file")
        String descriptionDesc;
        @Option(name="--configuration", usage="configuration properties file")
        String configDesc;

        ArgBean() {
        }
    }
}

