/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationAccess;
import org.lsst.ccs.config.MemoryDAO;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.framework.ConfigurationAccess;
import org.lsst.ccs.testers.components.NodeModularSubsystem;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.nodes.ComponentFactory;
import org.lsst.gruth.nodes.Utils;

public class BootUtils {
    static String userName = "";
    static String version = "1.0";
    static int level = 10;

    public static ComponentNode getDescriptiveNode(String pathName) throws Exception {
        ComponentNode componentNode = null;
        InputStream is = BootUtils.getInput(BootUtils.class, pathName);
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (ComponentNode)ois.readObject();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
        }
        return componentNode;
    }

    public static ComponentNode getEffectiveNode(ComponentNode descriptionNode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ComponentFactory fact = new ComponentFactory(descriptionNode);
        ComponentNode top = fact.buildObjectTreeFrom(descriptionNode);
        top.doCallsFromTop();
        return top;
    }

    public static ComponentNode getEffectiveNodeFromFile(String pathName) throws Exception {
        ComponentNode descriptiveNode = BootUtils.getDescriptiveNode(pathName);
        return BootUtils.getEffectiveNode(descriptiveNode);
    }

    public static Subsystem getRawSubsystemFromEffectiveNode(ComponentNode effectiveNode, String subsystemName, String configName, String tag) {
        NodeModularSubsystem system = new NodeModularSubsystem(subsystemName);
        system.registerNodes(effectiveNode);
        return system;
    }

    public static Subsystem getRawSubsystemFromEffectiveNode(ComponentNode effectiveNode, String pathName) {
        NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName);
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        return BootUtils.getRawSubsystemFromEffectiveNode(effectiveNode, subsystemName, configName, tag);
    }

    public static Subsystem rawSubsystemFromDescriptionNode(ComponentNode descriptionNode, String subsystemName, String configName, String tag) throws Exception {
        ComponentNode top = BootUtils.getEffectiveNode(descriptionNode);
        return BootUtils.getRawSubsystemFromEffectiveNode(top, subsystemName, configName, tag);
    }

    @Deprecated
    public static void bootSubsystemFromDescriptionNode(ComponentNode node, String subsystemName, String configName, String tag) throws Exception {
        Subsystem system = BootUtils.rawSubsystemFromDescriptionNode(node, subsystemName, configName, tag);
        system.start();
    }

    @Deprecated
    public static void bootSubsystemFromEffectiveNode(ComponentNode effectiveNode, String subsystemName, String configName, String tag) {
        Subsystem system = BootUtils.getRawSubsystemFromEffectiveNode(effectiveNode, subsystemName, configName, tag);
        system.start();
    }

    @Deprecated
    public static void bootSubsystemFromEffectiveNode(ComponentNode effectiveNode, String pathName) throws Exception {
        NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName);
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        BootUtils.bootSubsystemFromEffectiveNode(effectiveNode, subsystemName, configName, tag);
    }

    public static Subsystem getSubsystemFromFile(String pathName) throws Exception {
        return BootUtils.getSubsystemFromFile(pathName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName) throws Exception {
        LocalBootObject localBootObject = propertiesFileName == null ? new LocalBootObject(pathName) : new LocalBootObject(pathName, propertiesFileName);
        return localBootObject.getSubsystem();
    }

    public static void saveInCache(ComponentNode node, String subsystemName, String configName, String tag) {
    }

    public static ComponentNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static InputStream getInput(Class clazz, String pathName) throws IOException {
        InputStream is = null;
        File file = new File(pathName);
        if (file.exists()) {
            is = new FileInputStream(pathName);
        } else {
            is = clazz.getResourceAsStream(pathName);
            if (is == null) {
                is = clazz.getResourceAsStream("/" + pathName);
            }
            if (is == null) {
                throw new IllegalArgumentException("no resource " + pathName);
            }
        }
        return is;
    }

    public static NamesAndTag namesFromPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        int indexDot = pathName.lastIndexOf(46);
        int lastPath = pathName.lastIndexOf(47);
        String rawName = pathName.substring(lastPath + 1, indexDot);
        String[] elements = rawName.split("_");
        switch (elements.length) {
            case 3: {
                tag = elements[2];
            }
            case 2: {
                configName = elements[1];
            }
            case 1: {
                subsystemName = elements[0];
            }
        }
        return new NamesAndTag(subsystemName, configName, tag);
    }

    public static String baseNameFromNames(NamesAndTag namesAndTag) {
        return String.format("%s_%s_%s", namesAndTag.getSubsystemName(), namesAndTag.getConfigName(), namesAndTag.getTag());
    }

    public static class LocalBootObject {
        ComponentNode descriptiveNode;
        ComponentNode effectiveNode;
        Subsystem subsystem;
        String subsystemName;
        String configurationName;
        String tagName;

        public LocalBootObject(String pathName) throws Exception {
            this.setNames(pathName, null);
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            this.subsystemFromDescriptionNode(this.descriptiveNode, this.subsystemName, this.configurationName, this.tagName, null);
        }

        public LocalBootObject(String pathName, String configFileName) throws Exception {
            this.setNames(pathName, configFileName);
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            Properties configProps = null;
            if (configFileName != null) {
                configProps = new Properties();
                FileReader reader = new FileReader(configFileName);
                configProps.load(reader);
            }
            this.subsystemFromDescriptionNode(this.descriptiveNode, this.subsystemName, this.configurationName, this.tagName, configProps);
        }

        private void setNames(String pathName, String configFileName) {
            NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName);
            this.subsystemName = namesAndTag.getSubsystemName();
            this.configurationName = namesAndTag.getConfigName();
            this.tagName = namesAndTag.getTag();
            if (configFileName != null) {
                namesAndTag = BootUtils.namesFromPath(configFileName);
                if (!this.subsystemName.equals(namesAndTag.getSubsystemName())) {
                    throw new IllegalArgumentException(" subsystem names differs :" + this.subsystemName + " <> " + namesAndTag.getSubsystemName());
                }
                String newConfigName = namesAndTag.getConfigName();
                String newTagName = namesAndTag.getTag();
                if (this.configurationName.length() != 0 && this.configurationName.length() != 0) {
                    throw new IllegalArgumentException(" configuration name clash :" + this.configurationName + " <> " + newConfigName);
                }
                if (this.tagName.length() != 0 && newTagName.length() != 0) {
                    throw new IllegalArgumentException(" tag name clash :" + this.tagName + " <> " + newTagName);
                }
                if (newConfigName.length() != 0) {
                    this.configurationName = newConfigName;
                }
                if (newTagName.length() != 0) {
                    this.tagName = newTagName;
                }
            }
        }

        public ComponentNode getDescriptiveNode() {
            return this.descriptiveNode;
        }

        public ComponentNode getEffectiveNode() {
            return this.effectiveNode;
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getConfigurationName() {
            return this.configurationName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Object getRunningObject(String key) {
            return this.effectiveNode.getIndirect((Object)key);
        }

        private void subsystemFromDescriptionNode(ComponentNode componentNode, String subsystemName, String configName, String tag, Properties configProps) throws Exception {
            SubsystemDescription description = Factories.createSubsystemDescription(subsystemName, tag, userName, version, (Serializable)componentNode, DataFlavour.PURE_OBJECT_TREE, SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
            MemoryDAO dao = new MemoryDAO();
            dao.saveAbstractDescription(description);
            ConfigProfile configProfile = Factories.createConfigProfile(description, configName, tag, userName, level);
            if (configProps != null) {
                configProfile.mergeProperties(configProps);
                componentNode = configProfile.getModifiedConfigurationData();
            }
            dao.saveAbstractConfig(configProfile);
            this.effectiveNode = BootUtils.getEffectiveNode(componentNode);
            this.subsystem = BootUtils.getRawSubsystemFromEffectiveNode(this.effectiveNode, subsystemName, configName, tag);
            LocalConfigurationAccess configurationAccess = new LocalConfigurationAccess(configProfile);
            this.subsystem.setConfigurationAccess((ConfigurationAccess)configurationAccess);
        }
    }
}

