/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote.scripts;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.nodes.Utils;

public class RegisterDescriptionFromFile {
    ConfigurationBusClient busClient;

    public RegisterDescriptionFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public RegisterDescriptionFromFile() {
        this.busClient = new ConfigurationBusClient();
    }

    public DescriptionResult register(String pathName, String user, String version) throws Exception {
        ComponentNode componentNode = null;
        NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName);
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        InputStream is = BootUtils.getInput(RegisterDescriptionFromFile.class, pathName);
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (ComponentNode)ois.readObject();
        } else if (pathName.endsWith(".groovy") || pathName.endsWith(".groo")) {
            componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
        }
        SubsystemDescription description = Factories.createSubsystemDescription(subsystemName, tag, user, version, (Serializable)componentNode, DataFlavour.PURE_OBJECT_TREE, SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
        Object res = this.busClient.invoke("registerSubsystemDescription", description);
        return (DescriptionResult)res;
    }
}

