/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote.scripts;

import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.startup.BootUtils;

public class RegisterConfigurationFromFile {
    ConfigurationBusClient busClient;

    public RegisterConfigurationFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public RegisterConfigurationFromFile() {
        this.busClient = new ConfigurationBusClient();
    }

    public ProfileResult register(SubsystemDescription description, String pathName, String userName, int level) throws Exception {
        NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName);
        String subsystemName = namesAndTag.getSubsystemName();
        if (!subsystemName.equals(description.getSubsystemName())) {
            throw new IllegalArgumentException(subsystemName + "not coherent with " + description.getSubsystemName());
        }
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        InputStream is = BootUtils.getInput(RegisterConfigurationFromFile.class, pathName);
        Properties properties = new Properties();
        properties.load(is);
        ConfigProfile profile = Factories.createRawConfigProfile(description, configName, tag, userName, level);
        profile.mergeProperties(properties);
        Object res = this.busClient.invoke("registerConfigProfile", profile);
        return (ProfileResult)res;
    }
}

