/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.List;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.ValueEvent;

@MappedSuperclass
public abstract class ParameterConfiguration
implements Serializable,
PathObject {
    protected String value;

    protected ParameterConfiguration() {
    }

    protected ParameterConfiguration(String value) {
        this.value = value;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public abstract ParameterDescription getDescription();

    public abstract List<? extends ValueEvent> getValueEvents();

    public String getValue() {
        return this.value;
    }

    void setValue(String value) {
        this.value = value;
    }

    public Object checkValue(String value) throws IllegalArgumentException {
        ParameterDescription description = this.getDescription();
        return description.checkValue(value);
    }

    public void modifyValue(String value) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("read only value");
        }
        if (this.checkValue(value) != null) {
            this.setValue(value);
        }
    }

    public void modifyValueAfterCheck(String value) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("read only value");
        }
        this.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathObject)) {
            return false;
        }
        PathObject that = (PathObject)o;
        ParameterDescription description = this.getDescription();
        return description.getPath().equals(that.getPath());
    }

    public String toString() {
        return this.getId() + "{" + this.getId() + ": description=" + this.getDescription() + ", value='" + this.value + '\'' + '}';
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return this.getDescription().getPath();
    }
}

