/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.GhostSubsystemDescription;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.PastConfigProfile;
import org.lsst.ccs.config.PreparedConfiguration;
import org.lsst.ccs.config.RunHistory;

public class HibernateDAO
implements DBInterface {
    protected SessionFactory sessionFactory;
    Session session;
    Transaction currentTransaction;
    private boolean exceptionFired;

    public HibernateDAO() {
        this.initSession();
        this.session = this.sessionFactory.openSession();
    }

    protected void initSession() {
        try {
            Configuration configuration = new Configuration().configure();
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).buildServiceRegistry();
            this.sessionFactory = configuration.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable ex) {
            PackCst.CURLOG.log(Level.SEVERE, "Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void begin() {
        PackCst.CURLOG.fine("begin transaction");
        this.session = this.sessionFactory.getCurrentSession();
        this.exceptionFired = false;
        this.currentTransaction = this.session.beginTransaction();
    }

    @Override
    public void end() {
        PackCst.CURLOG.fine("end transaction");
        if (!this.exceptionFired) {
            this.session.flush();
            this.currentTransaction.commit();
            this.currentTransaction = null;
        }
    }

    @Override
    public void fail() {
        if (this.currentTransaction != null) {
            this.currentTransaction.rollback();
        }
    }

    @Override
    public void fail(Throwable th) {
        PackCst.CURLOG.log(Level.SEVERE, "", th);
        this.fail();
    }

    @Override
    public void saveSubsystemDescription(ASubsystemDescription newDescription) {
        newDescription.setStartTimestamp(System.currentTimeMillis());
        this.session.saveOrUpdate((Object)newDescription);
    }

    @Override
    public void saveGhostDescriptions(GhostSubsystemDescription ghosts) {
        this.session.save((Object)ghosts);
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) {
        String request = "from ASubsystemDescription where subsystemName = '" + name + "' and tag = '" + tag + "'";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        if (listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0);
        }
        return null;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(long id) {
        String request = "from ASubsystemDescription where id = " + id;
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        if (listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0);
        }
        return null;
    }

    @Override
    public GhostSubsystemDescription getGhostDescription(long id) {
        String request = "from GhostSubsystemDescription where id = '" + id + "'";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        if (listRes.size() == 1) {
            return (GhostSubsystemDescription)listRes.get(0);
        }
        return null;
    }

    @Override
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) {
        this.session.delete((Object)oldDescription);
        this.session.flush();
    }

    @Override
    public void saveConfigProfile(AConfigProfile newProfile) {
        newProfile.setStartTimestamp(System.currentTimeMillis());
        this.session.saveOrUpdate((Object)newProfile);
    }

    @Override
    public void savePastProfile(PastConfigProfile deprecatedProfile) {
        this.session.save((Object)deprecatedProfile);
    }

    @Override
    public AConfigProfile getActiveConfigProfile(String name, String tag) {
        String request = "from AConfigProfile where name = '" + name + "' and tag = '" + tag + "'";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        if (listRes.size() == 1) {
            return (AConfigProfile)listRes.get(0);
        }
        return null;
    }

    @Override
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) {
        this.session.delete((Object)oldProfile);
        this.session.flush();
    }

    @Override
    public void modifyParmConfig(AParameterConfiguration config) {
        this.session.saveOrUpdate((Object)config);
    }

    @Override
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description) {
        String request = "from AConfigProfile where subsystemId = '" + description.getId() + "'";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        return listRes;
    }

    @Override
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) {
        String request = "from PastConfigProfile where subsystemDesc.id = " + description.getId() + "";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        return listRes;
    }

    @Override
    public void saveRun(RunHistory runHistory) {
        this.session.save((Object)runHistory);
    }

    @Override
    public void savePreparedConfiguration(PreparedConfiguration preparedConfiguration) {
        this.session.save((Object)preparedConfiguration);
    }

    @Override
    public PreparedConfiguration getPreparedConfiguration(String subsystemName, String configName, String tag) {
        Query query;
        List listRes;
        String request = "from PreparedConfiguration where subsystemName = '" + subsystemName + "'";
        if (configName != null && !"".equals(configName)) {
            request = request + " and configName = '" + configName + "'";
        }
        if (tag != null && !"".equals(tag)) {
            request = request + " and tag = '" + tag + "'";
        }
        if ((listRes = (query = this.session.createQuery(request)).list()).size() == 1) {
            return (PreparedConfiguration)listRes.get(0);
        }
        return null;
    }

    @Override
    public void saveMachineConfiguration(MachineConfiguration machineConfiguration) {
        this.session.save((Object)machineConfiguration);
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) {
        String request = "from MachineConfiguration where macAddress = '" + macAddress + "'";
        Query query = this.session.createQuery(request);
        List listRes = query.list();
        if (listRes.size() == 1) {
            return (MachineConfiguration)listRes.get(0);
        }
        return null;
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) {
        Query query = this.session.createQuery(hqlString);
        return query.list();
    }

    @Override
    public void close() {
        this.session.close();
        this.sessionFactory.close();
    }
}

