/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.GhostParameterDescription;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;

@Entity
class GhostSubsystemDescription
extends SubsystemDescription {
    @Id
    private long id;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    protected Set<GhostParameterDescription> paramDescriptions;

    GhostSubsystemDescription() {
    }

    public GhostSubsystemDescription(ASubsystemDescription other) {
        super(other);
        this.id = other.getId();
        if (this.id == 0L) {
            throw new IllegalArgumentException("cannot create ghost from non registered object (where id is not initialized by database)");
        }
        this.setStartTimestamp(other.getStartTimestamp());
        HashSet<GhostParameterDescription> set = new HashSet<GhostParameterDescription>();
        Iterator<AParameterDescription> i$ = other.getParamDescriptions().iterator();
        while (i$.hasNext()) {
            AParameterDescription parmDesc;
            AParameterDescription realDesc = parmDesc = i$.next();
            set.add(new GhostParameterDescription(realDesc));
        }
        this.paramDescriptions = Collections.unmodifiableSet(set);
        this.setPreviousDescriptionID(other.getPreviousDescriptionID());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    void setId(long id) {
        this.id = id;
    }

    @Override
    public Set<? extends ParameterDescription> getParamDescriptionSet() {
        return this.getParamDescriptions();
    }

    public Set<GhostParameterDescription> getParamDescriptions() {
        return this.paramDescriptions;
    }

    void setParamDescriptions(Set<GhostParameterDescription> paramDescriptions) {
        this.paramDescriptions = Collections.unmodifiableSet(paramDescriptions);
    }

    @Override
    void setEndTimestamp(long endTimestamp) {
        super.setEndTimestamp(endTimestamp);
    }

    @Override
    public void addParameterDescriptions(ParameterDescription ... descriptions) {
        throw new UnsupportedOperationException("immutable description");
    }

    @Override
    public void addParameterDescriptions(Collection<ParameterDescription> descriptions) {
        throw new UnsupportedOperationException("immutable description");
    }

    @Override
    public void removeParameterDescriptions(ParameterDescription ... descriptions) {
        throw new UnsupportedOperationException("immutable description");
    }
}

