package org.lsst.ccs.startup;

import org.lsst.ccs.config.*;
import org.lsst.gruth.jutils.ComponentNode;

import java.io.*;
import java.util.Collection;
import java.util.Properties;

/**
 * creates a new Binary description file by merging a description file and a configuration properties file
 * @author bamade
 */
// Date: 21/06/12

public class LocalMergeToBinary {
    public static void main(String[] args) throws Exception {
        if(args.length < 2) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalMergeToBinary pathName propertiesFile [-boot]\n"
                    + " where filename is  xx.ser or xx.groovy or xx.groo\n"
                    + " where propertiesFile is  xx_configName_.properties\n"
                    + " pathName could be file (with '/' file separator) or resource path\n"
                    + " option -boot then boots a subsystem with all data");
            System.exit(1);
        }
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        String pathName = args[0] ;
        String propertiesFile = args[1] ;
        NamesAndTag namesAndTagOrigin = BootUtils.namesFromPath(pathName) ;
        NamesAndTag namesAndTagProperties = BootUtils.namesFromPath(propertiesFile) ;
        if(! namesAndTagOrigin.getSubsystemName().equals(namesAndTagProperties.getSubsystemName())) {
            throw new IllegalArgumentException(" subsystem names do not match : " + namesAndTagOrigin.getSubsystemName()
                                    + " " + namesAndTagProperties.getSubsystemName()) ;
        }
        if(namesAndTagProperties.getConfigName().equals(namesAndTagOrigin.getConfigName())) {
            throw new IllegalAccessException(" configuration with same name, creating a new file will destroy model") ;
        }
        InputStream is = BootUtils.getInput(LocalMergeToBinary.class, pathName) ;
        SubsystemDescription description ;
        if(pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(is) ;
            ComponentNode componentNode = (ComponentNode) ois.readObject() ;
            description = Factories.createRawSubsystemDescription(namesAndTagOrigin.getSubsystemName(), namesAndTagOrigin.getTag(),
                    "", "", componentNode, DataFlavour.PURE_OBJECT_TREE);
            ois.close() ;

        } else if(pathName.endsWith(".groovy") || pathName.endsWith(".groo")){
            description = Factories.createRawSubsystemDescription(namesAndTagOrigin.getSubsystemName(),
                    namesAndTagOrigin.getTag(), "", "", is, "ISO-8859-1") ;

        } else {
            throw new IllegalArgumentException(" not supported : " +pathName) ;
        }

        InputStream pis = BootUtils.getInput(LocalMergeToBinary.class, propertiesFile) ;
        Properties props = new Properties() ;
        props.load(pis);
        System.out.println(props);

        Collection<ParameterDescription> descriptions = description.getPossibleDescriptions(PackCst.DESIGNER_LEVEL) ;
        description.addParameterDescriptions(descriptions);

        ComponentNode res = description.getModifiedConfigurationData(props) ;

        String newPathName = namesAndTagProperties.toString()+".ser" ;
        OutputStream os = new FileOutputStream(newPathName) ;
        ObjectOutputStream oos = new ObjectOutputStream(os) ;
        //System.out.println(res);
        oos.writeObject(res);
        oos.flush();
        oos.close();
        if(args.length > 2) { //boot
            BootUtils.bootSubsystemFromDescriptionNode(res, namesAndTagProperties.getSubsystemName(),
                    namesAndTagProperties.getConfigName(), namesAndTagProperties.getTag());

        }


    }
}
