/**
 *<H1>Overview</H1>
 * The <TT>org.lsst.ccs.config</TT> package deals with configuration data.
 * Data used to fire subsystems and modules may be modified for testing purposes or to run the code
 *  in specific conditions.
 * <P>
 * This data is registered to a database so it can be queried to run a worker subsystem
 * and to know about any parameter value which was used at a given moment in time.
 * <P>
 *  This means that the database registers configuration data and worker subsystem executions
 *  (An <I>agent</I> on the buses listens to subsystem start and end operations and must know
 *  which configuration set was used).
 *  <P>
 *  Data describing a subsystem and its configuration is split in two parts:
 *  <UL>
 *      <LI> <B>Description</B> data: created and edited by subsystem designers.
 *      The initial descriptions of components and the properties of their parameters is in a resource file.
 *      The internal java structure used to describe and start a subsystem is an instance of <TT>ComponentNode</TT>
 *      (a "tree" structure). These can be generated from a Groovy DSL (Domain Specific Language) or from plain Java code.
 *      Thus the resource file can be a <TT>Serialized</TT> java object or a Groovy text that is dynamically compiled at runtime.
 *      <BR>
 *       This java Object can be used to extract information to create <TT>SubsystemDescription</TT> objects that will be stored
 *       in the database. Parameter data is stored in  a Set of <TT>ParameterDescription</TT> objects referenced by the
 *       overall description object.
 *       <BR>
 *        Parameter descriptions can be directly extracted from detailed information contained in the <TT>ComponentNode</TT>
 *        object but it can also be edited  and modified through a GUI before a description is saved through the Configuration
 *        Service.
 *
 *      <LI> <B>Configuration</B> data: created and edited by engineers.
 *      This data modifies a standard description that has been previously stored by the Configuration Service.
 *      The "edition" of this configuration data can be through text ( a simple ".properties" file) or through a GUI.
 *      <BR>
 *      A configuration object is an instance of <TT>ConfigProfile</TT> and contains a set of <TT>ParameterConfiguration</TT>.
 *      Each <TT>ParameterConfiguration</TT> object references the corresponding <TT>ParameterDescription</TT>
 *      So modifications to parameter values can be checked as soon as possible by matching the value to the description
 *      constraints.
 *  </UL>
 * Other Objects are stored in the database :
 * <UL>
 *     <LI> <TT>PreparedConfiguration</TT> that contains a "ready to use" component node that results from the merging
 *     of default description data with data modified by a configuration
 *     <LI> <TT>MachineConfiguration</TT> that describes the configuration to be run by a specific machine (known by its
 *     MacAddress).
 *     <LI> <TT>RunHistory</TT> which tells which subsystem with which configuration was running at any moement in time
 * </UL>
 *
 * Since historical data is important to know what happened the deprecated descriptions and configurations are kept in the
 * database. Each deprecated Data is described by a different class with slightly different properties.
 * <P>
 *   So , in fact, each description or configuration is known by client codes through abstract classes and there are different
 *   actual (<I>package friendly</I>) subclasses to describe objects that are "alive" and object that are deprecated.
 *  <BR>
 *   Thus :
 *   <UL>
 *       <LI> <TT>SubsystemDescription</TT> is subclassed by <TT>ASubsystemDescription</TT> for "active" objects
 *       and by  <TT>GhostSubsystemDescription</TT> objects.
 *       <BR>
 *       The <I>Ghost</I> objects are peculiar: they are created in parallel with the active object
 *       they represent but they are ready to handle deprecation.  Suppose you have a Configuration X
 *       that references Description Y, and now Configuration X is deprecated before Y. then the deprecated
 *       X references the ghost object. When Y is deprecated then only the "end date" of the ghost object
 *       is modified.
 *       <LI> <TT>ParameterDescription</TT> is subclassed by <TT>AParameterDescription</TT>
 *       and <TT>GhostParameterDescription</TT>
 *       <LI> <TT>ConfigProfile</TT> is subclassed by <TT>AConfigProfile</TT> and <TT>PastConfigProfile</TT>
 *       (these are not "ghost" objects: they are created only when the object is deprecated)
 *       <LI> <TT>ParameterConfiguration</TT> is subclassed by <TT>AParameterConfiguration</TT>
 *       and <TT>PastParameterConfiguration</TT>
 *   </UL>
 *
 *   All these objects are immutable once registered in the database (except date for ghost objects, and list of values
 *   in <TT>ParameterConfiguration</TT> objects handled during engineering mode)
 *
 *   The handling of complex strategies on top of the database is made through a <TT>ConfigurationFacade</TT>
 *   Object. But this is still a rather low level methods collection.
 *   <BR>
 *    So client codes are encouraged to use higher level codes that deal only with abstract classes:
 *    <UL>
 *        <LI> the <TT>Factories</TT> class provides static factory methods to create/copy objects
 *        <LI> the <TT>remote.ConfigurationService</TT> interface  and its implementations give access to
 *        a simpler "Configuration service"
 *    </UL>
 *   </BR>
 *
 *   A Collection of codes that can be used to start a subsystem can be found in the
 *   <TT>org.lsst.ccs.startup</TT> package: some use purely local data, some use a remote configuration
 *   service.
 *
 *   <P>
 *   Implementation of Configuration server can be found in <TT>org.lsst.ccs.config.remote</TT>
 *   package.
 *
 *
 */
package org.lsst.ccs.config;

