package org.lsst.ccs.config;

import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

import static org.lsst.ccs.config.PackCst.CURLOG;

/**
 * <TT>DBInterface</TT> implementation on top of Hibernate.
 * Beware: this is a multithreaded implementation so the configuration should contain:
 * <PRE>
 *      <property name="current_session_context_class">thread</property>
 * </PRE>
 * TODO: names of tables in a resource
 * @author bamade
 */
// Date: 13/04/12
    //TODO: centralize the requests: lot of code duplications!

public class HibernateDAO implements DBInterface{


    protected SessionFactory sessionFactory;
    org.hibernate.Session session ;
    org.hibernate.Transaction currentTransaction ;
    private boolean exceptionFired ;

    public HibernateDAO() {
        initSession() ;
        session = sessionFactory.openSession();
    }

    /*
    dangerous: method to be specialized (to get different service)
     */
    protected void initSession() {
        try {
            /**/
            Configuration configuration = new Configuration().configure() ;
            // Create the SessionFactory from standard (hibernate.cfg.xml)
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().
                    applySettings(configuration.getProperties()).buildServiceRegistry();
            sessionFactory = configuration.buildSessionFactory(serviceRegistry);
            /**/
            //sessionFactory = new AnnotationConfiguration().configure("hibernate.cfg.xml").buildSessionFactory();


            // config file.
        } catch (Throwable ex) {
            // Log the exception.
            CURLOG.log(Level.SEVERE, "Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }
    public  SessionFactory getSessionFactory() {
        return sessionFactory;
    }
    @Override
    public void begin() {
        CURLOG.fine("begin transaction");
        session = sessionFactory.getCurrentSession();
        exceptionFired = false ;
        currentTransaction = session.beginTransaction() ;
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void end() {
        // use of wasrollback not sure ...
        CURLOG.fine("end transaction");
        if(!exceptionFired) {
            session.flush();
            currentTransaction.commit() ;
            currentTransaction = null ;
        }
    }

    @Override
    public void fail() {
        if(currentTransaction != null) {
            currentTransaction.rollback();
        }
    }

    @Override
    public void fail(Throwable th) {
        CURLOG.log(Level.SEVERE,"",th);
        fail() ;
    }

    @Override
    public void saveSubsystemDescription(ASubsystemDescription newDescription) {
       newDescription.setStartTimestamp(System.currentTimeMillis());
        // paremeter description comments my be modified
        session.saveOrUpdate(newDescription); ;
    }

    @Override
    public void saveGhostDescriptions(GhostSubsystemDescription ghosts) {
        session.save(ghosts) ;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) {
        String request = "from ASubsystemDescription where subsystemName = '"+name+"' and tag = '"+tag +"'" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(long id) {
        String request = "from ASubsystemDescription where id = " +id  ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (ASubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public GhostSubsystemDescription getGhostDescription(long id) {
        String request = "from GhostSubsystemDescription where id = '"+id+"'" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (GhostSubsystemDescription)listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) {
        session.delete(oldDescription);
        // flush ?
        session.flush() ;
    }

    @Override
    public void saveConfigProfile(AConfigProfile newProfile) {
        newProfile.setStartTimestamp(System.currentTimeMillis());
        //TODO: what of referenced subsystem? dave? different cascade ?
        // remarks can be modified
        session.saveOrUpdate(newProfile);
    }

    @Override
    public void savePastProfile(PastConfigProfile deprecatedProfile) {
        session.save(deprecatedProfile) ;
    }

    @Override
    public AConfigProfile getActiveConfigProfile(String name, String tag) {
        String request = "from AConfigProfile where name = '"+name+"' and tag = '"+tag +"'" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (AConfigProfile) listRes.get(0) ;
        }
        return null ;
    }

    @Override
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) {
        session.delete(oldProfile);
        //flush ? YES otherwise does not work!
        session.flush() ;
    }

    @Override
    public void modifyParmConfig(AParameterConfiguration config) {
        session.saveOrUpdate(config);
    }

    @Override
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description) {
        //TODO: check if simpler join is not more coherent
        String request = "from AConfigProfile where subsystemId = '"+description.getId()+"'" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        return (Collection<AConfigProfile>)listRes ;
    }

    @Override
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) {
        //TODO: check if simpler  using id
        //TODO: RECHECK THIS! LOOKS FAULTY
        //String request = "from PastConfigProfile where subsystemDesc = "+description+"" ;
        String request = "from PastConfigProfile where subsystemDesc.id = "+description.getId()+"" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        return (Collection<PastConfigProfile>)listRes ;
    }

    @Override
    public void saveRun(RunHistory runHistory) {
        session.save(runHistory) ;
    }

    @Override
    public void savePreparedConfiguration(PreparedConfiguration preparedConfiguration) {
        session.save(preparedConfiguration);
    }

    @Override
    public PreparedConfiguration getPreparedConfiguration(String subsystemName, String configName, String tag) {
        String request = "from PreparedConfiguration where subsystemName = '" +subsystemName +"'" ;
         if(configName != null && !"".equals(configName)) {
                request += " and configName = '" + configName +"'" ;
         }
        if(tag != null && !"".equals(tag)) {
            request += " and tag = '" + tag +"'" ;
        }
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (PreparedConfiguration)listRes.get(0) ;
        }
        return null;
    }

    @Override
    public void saveMachineConfiguration(MachineConfiguration machineConfiguration) {
        session.save(machineConfiguration) ;
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) {
        String request = "from MachineConfiguration where macAddress = '" + macAddress + "'" ;
        Query query = session.createQuery(request) ;
        List listRes = query.list();
        if(listRes.size() == 1) {
            return (MachineConfiguration)listRes.get(0) ;
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) {
        Query query = session.createQuery(hqlString) ;
        return query.list() ;
    }

    //TODO : write a "pumping" query

    @Override
    public void close() {
        session.close();
        sessionFactory.close();
    }

}
