package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.SubsystemDescription;

import java.io.Serializable;

/**
 * Notification of a Subsystem Deprecation.
 * <BR/>
 * WARNING: the <TT>SubsystemDescription</TT> data may be changed in future releases
 * and replaced by a subsystem name (to avoid excessive load).
 * @author bamade
 */
// Date: 06/06/12

public class DescriptionDeprecationEvent implements Serializable {
    public final SubsystemDescription deprecating ;
    public final String detail;
    public final long stamp = System.currentTimeMillis() ;

    public DescriptionDeprecationEvent(SubsystemDescription deprecating, String detail) {
        this.deprecating = deprecating;
        this.detail = detail;
    }
}
