/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.utilities;

import groovy.util.Eval;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.Subsystem;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.types.GArray;
import org.lsst.gruth.types.GList;
import org.lsst.gruth.types.GMap;
import org.lsst.gruth.types.GStruct;

public class PersistentProperties
implements Serializable,
Cloneable {
    private static ArrayList<PersistentProperties> activeProperties = new ArrayList();
    private Store store;
    private String name;
    private Properties properties = new Properties();
    private volatile boolean modified;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (PersistentProperties props : activeProperties) {
                    Store store = props.store;
                    if (store == null || !props.modified) continue;
                    try {
                        store.commit();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public PersistentProperties(String name, Store store) {
        this.store = store;
        this.name = name;
        store.storeIsFor(this);
        activeProperties.add(this);
    }

    public PersistentProperties(String name) {
        this(name, new FileStore());
    }

    private Integer toInteger(String intString) {
        if (intString == null) {
            return null;
        }
        return new Integer(intString);
    }

    private Double toDouble(String doubleString) {
        if (doubleString == null) {
            return null;
        }
        return new Double(doubleString);
    }

    private Float toFloat(String floatString) {
        if (floatString == null) {
            return null;
        }
        return new Float(floatString);
    }

    private Boolean toBoolean(String booleanString) {
        if (booleanString == null) {
            return null;
        }
        return new Boolean(booleanString);
    }

    private Map toMap(String mapString) {
        if (mapString == null) {
            return null;
        }
        return GMap.valueOf((String)mapString);
    }

    private List toList(String listString) {
        if (listString == null) {
            return null;
        }
        return GList.valueOf((String)listString);
    }

    private <T> T toObject(Class<T> clazz, String objectString) {
        if (objectString == null) {
            return null;
        }
        if (clazz.isArray()) {
            return (T)GArray.valueOf((String)objectString, (String)clazz.getName());
        }
        Object obj = Eval.me((String)objectString);
        if (obj instanceof List) {
            return (T)GStruct.valueOf(clazz, (List)((List)obj));
        }
        if (obj instanceof Map) {
            return (T)GStruct.valueOf(clazz, (Map)((Map)obj));
        }
        throw new IllegalArgumentException(" format not available : " + objectString + "for " + clazz);
    }

    public Integer putInteger(String key, int value) {
        Object res = this.properties.setProperty(key, String.valueOf(value));
        Integer resInt = this.toInteger((String)res);
        this.modified = true;
        return resInt;
    }

    public Integer getInteger(String key) {
        return this.toInteger(this.properties.getProperty(key));
    }

    public Boolean putBoolean(String key, boolean bool) {
        Object res = this.properties.setProperty(key, String.valueOf(bool));
        Boolean resBool = this.toBoolean((String)res);
        this.modified = true;
        return resBool;
    }

    public Boolean getBoolean(String key) {
        return this.toBoolean(this.properties.getProperty(key));
    }

    public Double putDouble(String key, double val) {
        Object res = this.properties.setProperty(key, String.valueOf(val));
        Double resDbl = this.toDouble((String)res);
        this.modified = true;
        return resDbl;
    }

    public Double getDouble(String key) {
        return this.toDouble(this.properties.getProperty(key));
    }

    public Float putFloat(String key, float val) {
        Object res = this.properties.setProperty(key, String.valueOf(val));
        Float resDbl = this.toFloat((String)res);
        this.modified = true;
        return resDbl;
    }

    public Float getFloat(String key) {
        return this.toFloat(this.properties.getProperty(key));
    }

    private Object rawPutObject(String key, Object obj) {
        if (obj == null) {
            return this.properties.setProperty(key, null);
        }
        Object res = this.properties.setProperty(key, HollowParm.stringify((Object)obj));
        return res;
    }

    public String putString(String key, String value) {
        String res = (String)this.properties.setProperty(key, value);
        this.modified = true;
        return res;
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public <T, V extends T> T putArray(String key, Class<T> arrayClass, V value) {
        Object rawres = this.rawPutObject(key, value);
        T res = this.toObject(arrayClass, (String)rawres);
        this.modified = true;
        return res;
    }

    public <T> T getArray(String key, Class<T> arrayClass) {
        return this.toObject(arrayClass, this.properties.getProperty(key));
    }

    public <T> T putStruct(String key, Class<T> structClass, T value) {
        Object rawres = this.rawPutObject(key, value);
        T res = this.toObject(structClass, (String)rawres);
        this.modified = true;
        return res;
    }

    public <T> T getStruct(String key, Class<T> structClass) {
        return this.toObject(structClass, this.properties.getProperty(key));
    }

    public List putList(String key, List list) {
        Object rawres = this.rawPutObject(key, list);
        List res = this.toList((String)rawres);
        this.modified = true;
        return res;
    }

    public List getList(String key) {
        return this.toList(this.properties.getProperty(key));
    }

    public Map putMap(String key, Map map) {
        Object rawres = this.rawPutObject(key, map);
        Map res = this.toMap((String)rawres);
        this.modified = true;
        return res;
    }

    public Map getMap(String key) {
        return this.toMap(this.properties.getProperty(key));
    }

    private Object evalIt(String str) {
        String trimStr = str.trim();
        char first = trimStr.charAt(0);
        Object res = str;
        if (Character.isDigit(first) || first == '[') {
            res = Eval.me((String)trimStr);
        } else {
            if ("true".equalsIgnoreCase(trimStr)) {
                return new Boolean(true);
            }
            if ("false".equalsIgnoreCase(trimStr)) {
                return new Boolean(false);
            }
        }
        return res;
    }

    public Object putObject(String key, Object obj) {
        Object rawres = this.rawPutObject(key, obj);
        if (rawres != null) {
            rawres = this.evalIt((String)rawres);
        }
        this.modified = true;
        return rawres;
    }

    public Object getObject(String key) {
        String rawres = this.properties.getProperty(key);
        Object res = null;
        if (rawres != null) {
            res = this.evalIt(rawres);
        }
        return res;
    }

    public static class FileStore
    implements Store {
        String storeName;
        PersistentProperties persistentProperties;
        File currentFile;

        @Override
        public void storeIsFor(PersistentProperties props) {
            if (this.storeName != null) {
                throw new IllegalStateException("name already set for Store");
            }
            this.persistentProperties = props;
            this.storeName = props.name;
        }

        @Override
        public void commit() throws IOException {
            this.checkForFile();
            FileOutputStream fos = new FileOutputStream(this.currentFile);
            this.persistentProperties.properties.store(fos, "persistent properties store for " + this.persistentProperties.name);
            try {
                fos.close();
            }
            catch (IOException iOException) {}
            this.persistentProperties.modified = false;
        }

        private void checkForFile() throws IOException {
            if (this.currentFile == null) {
                URL url = Subsystem.class.getResource(String.valueOf(this.storeName) + ".properties");
                if (url != null) {
                    try {
                        this.currentFile = new File(url.toURI());
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                } else {
                    this.currentFile = new File(String.valueOf(this.storeName) + ".properties");
                }
            }
        }

        @Override
        public void update() throws IOException {
            this.checkForFile();
            FileInputStream fis = new FileInputStream(this.currentFile);
            this.persistentProperties.properties.load(fis);
            try {
                fis.close();
            }
            catch (IOException iOException) {}
            this.persistentProperties.modified = false;
        }
    }

    public static interface Store {
        public void storeIsFor(PersistentProperties var1);

        public void commit() throws IOException;

        public void update() throws IOException;
    }
}

