/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote.scripts;

import java.io.Closeable;
import java.io.IOException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;

public class ConfigurationBusClient
implements Closeable {
    String serverName;
    MessagingFactory fac;
    SynchronousCommandAgent dispenser;
    public static long TIME_OUT = 10000L;

    public ConfigurationBusClient(String serverName, String clientName) {
        this.serverName = serverName;
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        this.fac = MessagingFactory.getInstance().forSubsystem(clientName);
        this.dispenser = new SynchronousCommandAgent(this.fac);
    }

    public ConfigurationBusClient() {
        this("configServer", "client[" + Subsystem.getEthHardAddress() + "]");
    }

    public Object invoke(long timeout, String methodName, Object ... args) throws Exception {
        ModuleInvokerCommand command = new ModuleInvokerCommand(methodName, args);
        command.setDestination(this.serverName);
        if (timeout < 0L) {
            this.fac.sendCommand((Command)command);
            return null;
        }
        return this.dispenser.invoke((Command)command, timeout);
    }

    public Object invoke(String methodName, Object ... args) throws Exception {
        return this.invoke(TIME_OUT, methodName, args);
    }

    @Override
    public void close() throws IOException {
        this.fac.shutdownBusAccess();
    }
}

