/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.GhostSubsystemDescription;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.PastConfigProfile;
import org.lsst.ccs.config.PersistenceLayerException;
import org.lsst.ccs.config.PreparedConfiguration;
import org.lsst.ccs.config.RunHistory;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.gruth.jutils.ComponentNode;

public class ConfigurationFacade {
    private DBInterface dao;
    private DeprecationListener deprecationListener;
    private static final Integer ZERO = 0;
    ThreadLocal<Integer> stackState = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return ZERO;
        }
    };
    ReentrantLock lock = new ReentrantLock(true);

    public ConfigurationFacade(DBInterface dao) {
        this.dao = dao;
    }

    public void setDeprecationListener(DeprecationListener deprecationListener) {
        this.deprecationListener = deprecationListener;
    }

    synchronized void push() {
        Integer level = this.stackState.get();
        if (level == ZERO) {
            this.lock.lock();
            this.dao.begin();
        }
        this.stackState.set(level + 1);
    }

    synchronized void pop() {
        Integer level = this.stackState.get();
        if (level == ZERO) {
            throw new IllegalStateException("dao transaction stack empty");
        }
        level = level - 1;
        this.stackState.set(level);
        if (level == ZERO) {
            this.dao.end();
            this.lock.unlock();
        }
    }

    synchronized void failInDAO(Exception exc) {
        this.dao.fail(exc);
        this.stackState.set(ZERO);
        this.lock.unlock();
    }

    synchronized void failNThrow(Exception exc) throws PersistenceLayerException {
        PackCst.CURLOG.log(Level.SEVERE, "", (Throwable)exc, new String[0]);
        this.dao.end();
        this.stackState.set(ZERO);
        this.lock.unlock();
        throw new PersistenceLayerException(exc);
    }

    public SubsystemDescription registerSubsystemDescription(SubsystemDescription newDescription) throws PersistenceLayerException {
        if (!(newDescription instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("not a new description");
        }
        return this.registerSubsystemDescription((ASubsystemDescription)newDescription);
    }

    SubsystemDescription registerSubsystemDescription(ASubsystemDescription newDescription) throws PersistenceLayerException {
        String subsystemName = newDescription.getSubsystemName();
        String tag = newDescription.getTag();
        SubsystemDescription previous = null;
        this.push();
        try {
            ASubsystemDescription oldOne = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            long previousDescriptionID = 0L;
            if (oldOne != null) {
                if (oldOne.getId() == newDescription.getId()) {
                    PackCst.CURLOG.warning((Object)"trying to save an existing subsystem description : doing nothing", new String[0]);
                    this.pop();
                    return newDescription;
                }
                previous = this.deprecateSubsystemDescription(oldOne);
                previousDescriptionID = previous.getId();
                newDescription.setPreviousDescriptionID(previousDescriptionID);
            }
            this.dao.saveSubsystemDescription(newDescription);
            ASubsystemDescription registered = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            GhostSubsystemDescription ghost = new GhostSubsystemDescription(registered);
            this.dao.saveGhostDescriptions(ghost);
            this.pop();
            return newDescription.clone();
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    SubsystemDescription deprecateSubsystemDescription(ASubsystemDescription currentDescriptionInDB) {
        this.push();
        GhostSubsystemDescription ghost = this.dao.getGhostDescription(currentDescriptionInDB.getId());
        long endDate = System.currentTimeMillis();
        ghost.setEndTimestamp(endDate);
        currentDescriptionInDB.setEndTimestamp(endDate);
        Collection<AConfigProfile> profiles = this.dao.getActiveProfilesForSubsystem(currentDescriptionInDB);
        for (AConfigProfile profile : profiles) {
            this.deprecateConfigProfile(ghost, profile);
        }
        if (this.deprecationListener != null) {
            this.deprecationListener.subsystemDeprecating(ghost);
        }
        this.dao.deleteActiveSubsystemDescription(currentDescriptionInDB);
        this.pop();
        return ghost;
    }

    public SubsystemDescription deprecateSubsystemDescription(String subsystemName, String tag) throws PersistenceLayerException {
        this.push();
        try {
            SubsystemDescription res = null;
            ASubsystemDescription oldOne = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            if (oldOne != null) {
                res = this.deprecateSubsystemDescription(oldOne);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            return this.dao.getActiveSubsystemDescription(name, tag);
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ConfigProfile registerConfigProfile(ConfigProfile newProfile) throws PersistenceLayerException {
        if (!(newProfile instanceof AConfigProfile)) {
            throw new IllegalArgumentException("deprecated Profile");
        }
        return this.registerConfigProfile((AConfigProfile)newProfile);
    }

    ConfigProfile registerConfigProfile(AConfigProfile newProfile) throws PersistenceLayerException {
        this.push();
        try {
            long idSubs;
            ASubsystemDescription registered;
            ConfigProfile previous = null;
            long previousConfigID = 0L;
            String name = newProfile.getName();
            String tag = newProfile.getTag();
            AConfigProfile oldProfile = (AConfigProfile)this.getActiveConfigProfile(name, tag);
            if (oldProfile != null) {
                if (oldProfile.getId() == newProfile.getId()) {
                    PackCst.CURLOG.warning((Object)"trying to save an existing Config profile : doing nothing", new String[0]);
                    this.pop();
                    return newProfile;
                }
                if (!newProfile.getSubsystemName().equals(oldProfile.getSubsystemName())) {
                    throw new IllegalArgumentException("Name clash :  trying to create a configProfile with same name and different subsystem " + name + "/" + tag + " already exists for subsystem " + oldProfile.getSubsystemName());
                }
                GhostSubsystemDescription ghost = this.dao.getGhostDescription(oldProfile.getSubsystemId());
                previous = this.deprecateConfigProfile(ghost, oldProfile);
                previousConfigID = previous.getId();
                newProfile.setPreviousConfigID(previousConfigID);
            }
            if ((registered = this.dao.getActiveSubsystemDescription(idSubs = newProfile.getSubsystemId())) == null) {
                throw new IllegalArgumentException(" No such living subsystem description in database " + newProfile.getSubsystemDescription());
            }
            this.dao.saveConfigProfile(newProfile);
            this.pop();
            return newProfile.clone();
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    ConfigProfile deprecateConfigProfile(GhostSubsystemDescription ghost, AConfigProfile currentProfileInDB) {
        this.push();
        PastConfigProfile past = new PastConfigProfile(ghost, currentProfileInDB);
        this.dao.savePastProfile(past);
        if (this.deprecationListener != null) {
            this.deprecationListener.configProfileDeprecating(past);
        }
        this.dao.deleteActiveConfigProfile(currentProfileInDB);
        this.pop();
        return past;
    }

    public ConfigProfile deprecateConfigProfile(String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            ConfigProfile res = null;
            AConfigProfile currentProfile = (AConfigProfile)this.getActiveConfigProfile(name, tag);
            if (currentProfile != null) {
                GhostSubsystemDescription ghost = this.dao.getGhostDescription(currentProfile.getSubsystemId());
                res = this.deprecateConfigProfile(ghost, currentProfile);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ConfigProfile getActiveConfigProfile(String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            AConfigProfile res = this.dao.getActiveConfigProfile(name, tag);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ParameterConfiguration engineerParmConfig(ParameterConfiguration parameterConfiguration) throws PersistenceLayerException {
        if (!(parameterConfiguration instanceof AParameterConfiguration)) {
            throw new IllegalArgumentException("not a registered active  parameterConfiguraiton");
        }
        AParameterConfiguration config = (AParameterConfiguration)parameterConfiguration;
        if (config.getId() == 0L) {
            throw new IllegalArgumentException("not a registered parameterConfiguraiton");
        }
        if (!config.isCopy()) {
            throw new IllegalArgumentException("parameterConfiguration not in engineering mode");
        }
        this.push();
        try {
            this.pop();
            this.dao.modifyParmConfig(config);
            return config;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public void registerRun(String subsystemName, String configName, String tag, long startTime) throws PersistenceLayerException {
        this.push();
        try {
            List<?> list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and timeNext = 0");
            if (list.size() != 0) {
                if (list.size() > 1) {
                    PackCst.CURLOG.warning((Object)"multiple runs with no next run!", new String[0]);
                }
                RunHistory previousRun = (RunHistory)list.get(0);
                previousRun.setTimeNext(startTime);
                if (previousRun.getEndTimestampLimit() == PackCst.STILL_VALID) {
                    previousRun.setEndTimestampLimit(startTime - 1L);
                    previousRun.setEndGuessed(true);
                }
            }
            RunHistory run = new RunHistory(subsystemName, configName, tag, startTime);
            this.dao.saveRun(run);
            this.pop();
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public void endRun(String subsystemName, String configName, String tag, long endTime) throws PersistenceLayerException {
        this.push();
        if (configName == null) {
            configName = "";
        }
        if (tag == null) {
            tag = "";
        }
        try {
            List<?> list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and endTimestampLimit = " + PackCst.STILL_VALID);
            if (list.size() == 0) {
                list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and timeNext = 0");
                if (list.size() != 0) {
                    if (list.size() > 1) {
                        PackCst.CURLOG.warning((Object)"multiple runs with no next run!", new String[0]);
                    }
                    RunHistory previousRun = (RunHistory)list.get(0);
                    long previousEnd = previousRun.getEndTimestampLimit();
                    long fakeStart = previousEnd + 1L;
                    previousRun.setTimeNext(fakeStart);
                    RunHistory run = new RunHistory(subsystemName, configName, tag, fakeStart);
                    run.setStartGuessed(true);
                    run.setEndTimestampLimit(endTime);
                    this.dao.saveRun(run);
                }
            } else {
                for (RunHistory run : list) {
                    String runTagName;
                    String runConfigName = run.getConfigurationName();
                    if (runConfigName == null) {
                        runConfigName = "";
                    }
                    if ((runTagName = run.getTag()) == null) {
                        runTagName = "";
                    }
                    if (runConfigName.equals(configName) && runTagName.equals(tag)) {
                        run.setEndTimestampLimit(endTime);
                        continue;
                    }
                    PackCst.CURLOG.log(Level.WARNING, "run with no end date", (Object)run, new String[0]);
                }
            }
            this.pop();
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreparedConfiguration registerPreparedConfiguration(String subsystemName, String configName, String tag, String user) throws PersistenceLayerException {
        this.push();
        try {
            PreparedConfiguration res;
            if (configName == null || "".equals(configName)) {
                SubsystemDescription description = this.getActiveSubsystemDescription(subsystemName, tag);
                if (description == null) {
                    this.pop();
                    return null;
                }
                ComponentNode componentNode = description.getTopComponentNode();
                res = new PreparedConfiguration(String.valueOf(subsystemName) + "_default", tag, subsystemName, user, false, componentNode);
            } else {
                String registeredName;
                ConfigProfile configProfile = this.getActiveConfigProfile(configName, tag);
                if (subsystemName != null && !"".equals(subsystemName) && !(registeredName = configProfile.getSubsystemDescription().getSubsystemName()).equals(subsystemName)) {
                    throw new IllegalArgumentException(String.valueOf(subsystemName) + "differs from " + registeredName + " in request");
                }
                res = new PreparedConfiguration(configProfile);
            }
            this.dao.savePreparedConfiguration(res);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ComponentNode getActiveComponentNode(String subsystemName, String configName, String tag) throws PersistenceLayerException {
        this.push();
        try {
            ComponentNode res = null;
            List<?> list = this.dao.simpleHQLRequest("from PreparedConfiguration where  subsystemName = '" + subsystemName + "' AND configName = '" + configName + "' AND tag = '" + tag + "'");
            if (list.size() != 0) {
                res = ((PreparedConfiguration)list.get(0)).getConfiguredData();
            } else if (configName != null && !"".equals(configName)) {
                AConfigProfile configProfile = this.dao.getActiveConfigProfile(configName, tag);
                if (subsystemName != null && !"".equals(subsystemName) && !subsystemName.equals(configProfile.getSubsystemName())) {
                    throw new IllegalArgumentException(String.valueOf(subsystemName) + "differs from " + configProfile.getSubsystemName() + " in config profile");
                }
                res = configProfile.getModifiedConfigurationData();
            } else {
                ASubsystemDescription description = this.dao.getActiveSubsystemDescription(subsystemName, tag);
                if (description != null) {
                    res = description.getTopComponentNode();
                }
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ComponentNode getActiveComponentNode(MachineConfiguration machineConfiguration) throws PersistenceLayerException {
        String subsystemName = machineConfiguration.getSubsystemName();
        String configName = machineConfiguration.getConfigName();
        String tag = machineConfiguration.getTag();
        return this.getActiveComponentNode(subsystemName, configName, tag);
    }

    public void registerMachineConfiguration(MachineConfiguration machineConfiguration) throws PersistenceLayerException {
        this.push();
        try {
            this.dao.saveMachineConfiguration(machineConfiguration);
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public MachineConfiguration getMachineConfiguration(String macAddress) throws PersistenceLayerException {
        this.push();
        try {
            MachineConfiguration res = this.dao.getMachineConfiguration(macAddress);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ConfigProfile getConfigRunningAt(String subsystemName, long date) throws PersistenceLayerException {
        this.push();
        try {
            List<?> listRun = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and startTimeStamp < " + date + " and endTimeStampLimit > " + date + " ");
            int numberRuns = listRun.size();
            if (numberRuns != 0) {
                if (numberRuns > 1) {
                    PackCst.CURLOG.log(Level.WARNING, "multiple runs in same time span", listRun, new String[0]);
                    Collections.sort(listRun, new Comparator(){

                        public int compare(Object o, Object o1) {
                            Long longA = ((RunHistory)o).getStartTimestamp();
                            Long longB = ((RunHistory)o1).getStartTimestamp();
                            return longA.compareTo(longB);
                        }
                    });
                }
                RunHistory lastRun = (RunHistory)listRun.get(numberRuns - 1);
                return this.getConfigValidAt(lastRun.getConfigurationName(), lastRun.getTag(), date);
            }
            return null;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ConfigProfile getConfigValidAt(String configName, String configTag, long date) throws PersistenceLayerException {
        this.push();
        try {
            List<?> list = this.dao.simpleHQLRequest("from AConfigProfile where name ='" + configName + "' and tag ='" + configTag + "' and startTimestamp <= " + date + " ");
            if (list.size() != 0) {
                this.pop();
                return (ConfigProfile)list.get(0);
            }
            list = this.dao.simpleHQLRequest("from PastConfigProfile where name ='" + configName + "' and tag ='" + configTag + "' and startTimestamp <= " + date + " and endTimestamp >= " + date + " ");
            if (list.size() != 0) {
                this.pop();
                return (ConfigProfile)list.get(0);
            }
            this.pop();
            return null;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public String getActiveValueAt(String subsystemName, String parameterPath, long date) throws PersistenceLayerException {
        ConfigProfile profile = this.getConfigRunningAt(subsystemName, date);
        if (profile == null) {
            PackCst.CURLOG.warning((Object)("no running profile at " + new Date(date) + "for subsystem " + subsystemName), new String[0]);
            return null;
        }
        return profile.getValueAt(parameterPath, date);
    }

    public String getValueValidAt(String profileName, String profileTag, String parameterPath, long date) throws PersistenceLayerException {
        ConfigProfile profile = this.getConfigValidAt(profileName, profileTag, date);
        return profile.getValueAt(parameterPath, date);
    }

    public ConfigProfile getPrevious(ConfigProfile current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getPreviousConfigID();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            ConfigProfile res = null;
            List<?> list = this.dao.simpleHQLRequest("from PastConfigProfile where id = '" + id + "'");
            if (list.size() != 0) {
                res = (ConfigProfile)list.get(0);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public ConfigProfile getNext(ConfigProfile current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getId();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            ConfigProfile res = null;
            List<?> list = this.dao.simpleHQLRequest("from AConfigProfile where previousConfigID = '" + id + "'");
            if (list.size() != 0) {
                res = (ConfigProfile)list.get(0);
            } else {
                list = this.dao.simpleHQLRequest("from PastConfigProfile where previousConfigID = '" + id + "'");
                if (list.size() != 0) {
                    res = (ConfigProfile)list.get(0);
                }
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public SubsystemDescription getPrevious(SubsystemDescription current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getPreviousDescriptionID();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            SubsystemDescription res = null;
            List<?> list = this.dao.simpleHQLRequest("from GhostSubsystemDescription where id = '" + id + "'");
            if (list.size() != 0) {
                res = (SubsystemDescription)list.get(0);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }

    public List<?> simpleHQLRequest(String hqlString) throws PersistenceLayerException {
        this.push();
        try {
            List<?> res = this.dao.simpleHQLRequest(hqlString);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            this.failInDAO(exc);
            throw new PersistenceLayerException(exc);
        }
    }
}

