package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.*;
import org.lsst.ccs.framework.Module;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

/**
 * A CCS module that delegates Configuration Service calls to a local
 * <TT>ConfigurationServiceImpl</TT> object.
 * @author bamade
 */
// Date: 07/06/12

public class ConfigurationServerModule extends Module implements ConfigurationService{
    ConfigurationServiceImpl service =  ConfigurationServiceImpl.ON_HIBERNATE;
    ConfigurationFacade facade = service.getFacade() ;

    public ConfigurationServerModule() {
        setName("main");
    }

    public ConfigurationServerModule(ConfigurationServiceImpl service) {
        setName("main");
        this.service = service;
    }

    @Override
    public DescriptionResult registerSubsystemDescription(SubsystemDescription newDescription) throws RemoteException {
        return service.registerSubsystemDescription(newDescription);
    }

    @Override
    public DescriptionResult deprecateSubsystemDescription(String subsystemName, String tag) throws RemoteException {
        return service.deprecateSubsystemDescription(subsystemName, tag);
    }

    @Override
    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws RemoteException {
        return service.getActiveSubsystemDescription(name, tag) ;
    }

    @Override
    public ProfileResult registerConfigProfile(ConfigProfile newProfile) throws RemoteException {
        return service.registerConfigProfile(newProfile);
    }

    @Override
    public ProfileResult registerConfiguration(String subsystemName, String configurationName, String tag,
                                               String user, int level , Properties props) throws RemoteException{
        return service.registerConfiguration(subsystemName,configurationName,tag,user,level,props) ;
    }

    @Override
    public ProfileResult deprecateConfigProfile(String name, String tag) throws RemoteException {
        return service.deprecateConfigProfile(name, tag);
    }

    @Override
    public ConfigProfile getActiveConfigProfile(String name, String tag) throws RemoteException {
        return service.getActiveConfigProfile(name, tag) ;
    }

    @Override
    public ParameterConfiguration modifyParmConf(ParameterConfiguration engineeringModeParm) throws RemoteException {
        return service.modifyParmConf(engineeringModeParm) ;
    }

    @Override
    public ConfigProfile getConfigRunningAt(String subsystemName, long date) throws RemoteException {
        return service.getConfigRunningAt(subsystemName, date);
    }

    @Override
    public String getActiveValueAt(String subsystemName, String parameterPath, long date) throws RemoteException {
        return service.getActiveValueAt(subsystemName,parameterPath,date);
    }


    @Override
    public ConfigProfile getConfigValidAt(String name, String tag, long date) throws RemoteException {
        return service.getConfigValidAt(name, tag, date);
    }


    @Override
    public String getValueValidAt(String profileName, String profileTag, String parameterPath, long date) throws RemoteException {
        return service.getValueValidAt(profileName, profileTag, parameterPath, date);
    }

    @Override
    public ConfigProfile getPrevious(ConfigProfile current) throws RemoteException {
        return service.getPrevious(current);
    }

    @Override
    public ConfigProfile getNext(ConfigProfile current) throws RemoteException {
        return service.getNext(current);
    }

    @Override
    public SubsystemDescription getPrevious(SubsystemDescription current) throws RemoteException {
        return service.getPrevious(current);
    }

    @Override
    public void createPreparedConfiguration(String subsystemName, String configName, String tag, String user) throws RemoteException {
        service.createPreparedConfiguration(subsystemName,configName,tag, user);
    }

    @Override
    public void registerMachineConfiguration(MachineConfiguration machineConfiguration) throws RemoteException {
        service.registerMachineConfiguration(machineConfiguration);
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) throws RemoteException {
        return service.getMachineConfiguration(macAddress) ;
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) throws RemoteException {
        return service.simpleHQLRequest(hqlString);
    }

    //TODO : register run events by listening to Status bus!


}
