/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.command;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.lsst.ccs.subsystem.command.SubsystemCommandParameterDefinition;
import org.lsst.ccs.subsystem.command.annotations.SubsystemCommandParameter;

public class SubsystemCommandDefinition
implements Serializable {
    private String name;
    private String description;
    private String abbreviation;
    private SubsystemCommandParameterDefinition[] params;
    private String target;

    public SubsystemCommandDefinition(String target, Method method) {
        this.name = method.getName();
        this.target = target;
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] parAnnotations = method.getParameterAnnotations();
        this.params = new SubsystemCommandParameterDefinition[types.length];
        int i = 0;
        while (i < types.length) {
            String parName = "par" + i;
            String parDescription = "";
            Annotation[] annotationArray = parAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a instanceof SubsystemCommandParameter) {
                    SubsystemCommandParameter paramAnnotation = (SubsystemCommandParameter)a;
                    parName = paramAnnotation.getName().isEmpty() ? parName : paramAnnotation.getName();
                    parDescription = paramAnnotation.getDescription();
                    break;
                }
                ++n2;
            }
            this.params[i] = new SubsystemCommandParameterDefinition(parName, types[i], parDescription, i);
            ++i;
        }
    }

    public String toString() {
        String out = "Method " + this.name + " with ";
        if (this.params.length == 0) {
            out = String.valueOf(out) + "no parameters\n";
        } else {
            out = String.valueOf(out) + this.params.length + " parameters: \n";
            int i = 0;
            while (i < this.params.length) {
                out = String.valueOf(out) + this.params[i].getName() + " " + this.params[i].getType() + " " + this.params[i].getPosition() + " " + this.params[i].getDescription() + "\n";
                ++i;
            }
        }
        return out;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getTarget() {
        return this.target;
    }

    public SubsystemCommandParameterDefinition[] getParams() {
        return this.params;
    }
}

