/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import groovy.lang.Range;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.gruth.jutils.IncompatibleTypeException;

public abstract class HollowParm<T extends Serializable>
implements Serializable,
Cloneable {
    protected T value;
    protected boolean set;
    protected boolean readOnly = false;
    protected Properties properties;

    protected HollowParm() {
    }

    protected HollowParm(T value) {
        this.value = value;
        if (value != null) {
            this.set = true;
        }
    }

    protected HollowParm(T value, Map<?, ?> map) {
        this(value);
        this.setProperties(map);
    }

    final void setProperties(Map<?, ?> map) {
        this.properties = new Properties();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object valProp = entry.getValue();
            String valPropStr = HollowParm.stringify(valProp);
            valPropStr = valProp instanceof BigDecimal ? ((BigDecimal)valProp).toPlainString() : String.valueOf(valProp);
            this.properties.setProperty(entry.getKey().toString(), valPropStr);
        }
    }

    public static String stringify(Object obj) {
        String res;
        if (obj instanceof BigDecimal) {
            res = ((BigDecimal)obj).toPlainString();
        } else if (obj instanceof Range) {
            Range range = (Range)obj;
            Comparable lower = range.getFrom();
            Comparable upper = range.getTo();
            res = String.valueOf(HollowParm.stringify(lower)) + ".." + HollowParm.stringify(upper);
        } else {
            res = obj instanceof Map ? HollowParm.toMapString((Map)obj) : (obj instanceof List ? HollowParm.toListString((List)obj) : (obj.getClass().isArray() ? HollowParm.toArrayString(obj) : String.valueOf(obj)));
        }
        return res;
    }

    private static String toArrayString(Object obj) {
        StringBuilder builder = new StringBuilder("[");
        int size = Array.getLength(obj);
        int ix = 0;
        while (ix < size) {
            Object item = Array.get(obj, ix);
            if (item instanceof String) {
                builder.append("'").append(item).append("'");
            } else {
                builder.append(HollowParm.stringify(item));
            }
            if (ix < size - 1) {
                builder.append(",");
            }
            ++ix;
        }
        builder.append("]");
        return builder.toString();
    }

    private static String toListString(List list) {
        StringBuilder builder = new StringBuilder("[");
        int size = list.size();
        int ix = 0;
        while (ix < size) {
            Object item = list.get(ix);
            if (item instanceof String) {
                builder.append("'").append(item).append("'");
            } else {
                builder.append(HollowParm.stringify(item));
            }
            if (ix < size - 1) {
                builder.append(",");
            }
            ++ix;
        }
        builder.append("]");
        return builder.toString();
    }

    private static String toMapString(Map map) {
        StringBuilder builder = new StringBuilder("[");
        Set entries = map.entrySet();
        int size = entries.size();
        int ix = 0;
        for (Map.Entry entry : entries) {
            builder.append(entry.getKey()).append(":");
            Object item = entry.getValue();
            if (item instanceof String) {
                builder.append("'").append(item).append("'");
            } else {
                builder.append(HollowParm.stringify(item));
            }
            if (ix < size - 1) {
                builder.append(",");
            }
            ++ix;
        }
        builder.append("]");
        return builder.toString();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (this.readOnly) {
            return;
        }
        this.value = value;
        this.set = value != null;
    }

    public void setNullValue() {
        if (this.readOnly) {
            return;
        }
        this.value = null;
        this.set = true;
    }

    public void clear() {
        if (this.readOnly) {
            return;
        }
        this.setValue(null);
    }

    public void modifyChecked(Object obj) {
        if (this.readOnly) {
            return;
        }
        if (obj == null) {
            this.setNullValue();
            return;
        }
        Class<?> clazz = obj.getClass();
        Class<T> myClass = this.getValueClass();
        if (!myClass.isAssignableFrom(clazz)) {
            throw new IncompatibleTypeException(myClass, clazz);
        }
        this.value = (Serializable)obj;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        return HollowParm.stringify(this.value);
    }

    public abstract Class<T> getValueClass();

    public HollowParm<T> addProperties(Map.Entry<String, String> ... entries) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Map.Entry<String, String>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, String> entry = entryArray[n2];
            this.properties.setProperty(entry.getKey(), entry.getValue());
            ++n2;
        }
        return this;
    }

    public HollowParm clone() {
        HollowParm nextOne = null;
        try {
            nextOne = (HollowParm)super.clone();
            if (this.properties != null) {
                nextOne.properties = (Properties)this.properties.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return nextOne;
    }
}

