package org.lsst.ccs.startup;

import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.utilities.structs.UniquePair;
import org.lsst.gruth.jutils.ComponentNode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author bamade
 */
// Date: 20/11/12

public class NodeLookup  implements ComponentLookupService{
    private ComponentNode top ;
    private Map<String,Object> aliases = new HashMap<String,Object>() ;

    public NodeLookup(ComponentNode top) {
        this.top = top;
    }

    @Override
    public Object getComponentByName(String name) {
        Object res = top.getIndirect(name);
        if(res == null) {
            return aliases.get(name) ;
        }
        return res ;
    }

    /**
     * aliases cannot override names in name componentNode structure
     * @param alias
     * @param object
     */
    @Override
    public void aliasObject(String alias, Object object){
        aliases.put(alias, object ) ;
    }

    @Override
    public <T> Map<String, T> getChildren(String parentName, Class<T> classFilter) {
        ComponentNode current = (ComponentNode) top.getNodeByName(parentName);
        ArrayList<ComponentNode> children =  current.getChildren();
        LinkedHashMap<String, T> mapRes = new LinkedHashMap<String, T>(children.size()) ;
        for(ComponentNode child: children) {
            Object realValue = child.getRealValue();
            if(classFilter.isAssignableFrom(realValue.getClass())) {
                T realChild = (T) realValue ;
                String key = child.getKey() ;
                mapRes.put(key, realChild) ;
            }
        }
        return mapRes;
    }

    @Override
    public Map.Entry<String, Object> getParent(String componentName) {
        ComponentNode current = (ComponentNode) top.getNodeByName(componentName);
        ComponentNode parent = (ComponentNode) current.getParent();
        String key = parent.getKey() ;
        Object value = parent.getRealValue() ;
        return  new UniquePair<String, Object>(key, value) ;
    }
}
