/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.Constraints;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.HollowParm;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    private ASubsystemDescription subsystemDescription;
    private AConfigProfile baseProfile;
    private AConfigProfile currentProfile;
    private boolean inEngineeringMode;
    private MessagingFactory fac;

    public LocalConfigurationProxy(ConfigProfile configProfile) {
        this.baseProfile = (AConfigProfile)configProfile;
        this.subsystemDescription = this.baseProfile.getSubsystemDesc();
    }

    public String getConfigurationName() {
        return this.currentProfile.getName();
    }

    public String getTagName() {
        return this.currentProfile.getTag();
    }

    public synchronized void startNewConfigurationContext() {
        if (this.inEngineeringMode) {
            throw new IllegalStateException("already in engineering mode");
        }
        this.inEngineeringMode = true;
        this.currentProfile = new AConfigProfile(this.baseProfile, this.baseProfile.getName(), this.baseProfile.getTag(), "", 10, true);
    }

    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path;
        ParameterDescription parameterDescription;
        String strValue = value instanceof String ? (String)value : HollowParm.stringify((Object)value);
        if (!this.inEngineeringMode) {
            this.startNewConfigurationContext();
        }
        if ((parameterDescription = this.subsystemDescription.fetch(path = new ParameterPath(componentName, "", parameterName))) == null) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.subsystemDescription.getParamDescriptions());
        }
        if (parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
        Object res = parameterDescription.checkValue(strValue);
        return new ViewValue(strValue, res);
    }

    public void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), value);
    }

    public void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : HollowParm.stringify((Object)value);
        this.currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), strValue);
    }

    public synchronized void registerConfiguration(String configurationName, String tagName) throws IOException {
        NamesAndTag namesAndTag = new NamesAndTag(this.subsystemDescription.getSubsystemName(), configurationName, tagName);
        this.baseProfile = new AConfigProfile(this.currentProfile, this.currentProfile.getName(), this.currentProfile.getTag(), "", 10, false);
        this.currentProfile = this.baseProfile.clone();
        String baseName = BootUtils.baseNameFromNames(namesAndTag);
        PrintWriter printWriter = new PrintWriter(String.valueOf(baseName) + ".properties", "UTF-8");
        this.currentProfile.generateConfigProperties(printWriter);
        this.inEngineeringMode = false;
        printWriter.flush();
        printWriter.close();
    }

    public void dropModifications() {
        this.currentProfile = this.baseProfile.clone();
        this.inEngineeringMode = false;
    }

    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName();
        Object res = Constraints.check(type, strValue, null);
        return res;
    }

    public void setMessagingFactory(MessagingFactory factory) {
        this.fac = factory;
    }
}

