package org.lsst.ccs.config;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * Registers the date of a value change in engineering mode.
 * @author bamade
 */
// Date: 21/05/12

    @MappedSuperclass
public abstract class ValueEvent implements Serializable {
    private long time ;
    private String value ;

    protected ValueEvent() {

    }

    protected ValueEvent( long time, String value) {
        this.time = time;
        this.value = value;
    }

    public abstract long getId() ;

    public long getTime() {
        return time;
    }

     void setTime(long time) {
        this.time = time;
    }

    public String getValue() {
        return value;
    }

     void setValue(String value) {
        this.value = value;
    }
}
