/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.AValueEvent;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.HollowParm;

@Table(name="AConfigProfile", uniqueConstraints={@UniqueConstraint(columnNames={"name", "tag"})})
@Entity
@Immutable
class AConfigProfile
extends ConfigProfile
implements Cloneable {
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne(fetch=FetchType.EAGER)
    private ASubsystemDescription subsystemDesc;
    private long subsystemId;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<AParameterConfiguration> parameterConfigurations = new HashSet<AParameterConfiguration>();
    @Transient
    private Set<AParameterConfiguration> unModifiableConfigurations = Collections.unmodifiableSet(this.parameterConfigurations);

    AConfigProfile() {
    }

    public AConfigProfile(ASubsystemDescription subsystemDesc, String name, String tag, String userName, int level) {
        super(name, tag, userName, level);
        this.subsystemDesc = subsystemDesc;
        this.subsystemId = subsystemDesc.getId();
        if (this.subsystemId == 0L) {
            throw new IllegalArgumentException("Subsystem description should have been registered in database");
        }
        long endDate = subsystemDesc.getEndTimestamp();
        if (endDate != PackCst.STILL_VALID) {
            throw new IllegalArgumentException("using deprecated subsystem");
        }
    }

    public AConfigProfile(AConfigProfile anotherConfig, String name, String tag, String userName, int level, boolean toEngineering) {
        this(anotherConfig.getSubsystemDesc(), name, tag, userName, level);
        this.setBeenInEngineeringMode(toEngineering);
        for (AParameterConfiguration parmConfig : anotherConfig.getParameterConfigurations()) {
            AParameterConfiguration copyParm = AParameterConfiguration.copyWithoutEvents(parmConfig);
            if (anotherConfig.isBeenInEngineeringMode()) {
                int size;
                List<AValueEvent> eventList = parmConfig.valueEvents;
                if (toEngineering) {
                    if (eventList != null) {
                        for (AValueEvent event : eventList) {
                            copyParm.addValueEvent(event);
                        }
                    }
                    copyParm.setCopy(true);
                } else if (eventList != null && (size = eventList.size()) > 0) {
                    AValueEvent event = eventList.get(size - 1);
                    copyParm.setValue(event.getValue());
                }
            }
            this.addParameterConfigurations(copyParm);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public SubsystemDescription getSubsystemDescription() {
        return this.subsystemDesc;
    }

    @Override
    public Set<? extends ParameterConfiguration> getModifiedParameters() {
        return this.getParameterConfigurations();
    }

    @Override
    public void temporaryChangeConfigurationValue(ParameterConfiguration parameter, long time, String value) {
        if (!this.isBeenInEngineeringMode()) {
            throw new IllegalStateException("ConfigProfile not in Engineering mode");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("no such ParameterConfiguration");
        }
        AParameterConfiguration aParameterConfiguration = (AParameterConfiguration)this.fetch(parameter);
        aParameterConfiguration.addValueEvent(new AValueEvent(time, value));
    }

    @Override
    public ParameterConfiguration temporaryChangeConfigurationValue(String parameterPath, long time, String value) {
        ParameterPath path = ParameterPath.valueOf(parameterPath);
        ParameterConfiguration parameter = this.fetch(path);
        if (parameter == null) {
            AParameterDescription description = (AParameterDescription)this.subsystemDesc.fetch(path);
            parameter = new AParameterConfiguration(description);
            this.addParameterConfigurations(parameter);
        }
        this.temporaryChangeConfigurationValue(parameter, time, value);
        return parameter;
    }

    ASubsystemDescription getSubsystemDesc() {
        return this.subsystemDesc;
    }

    void setSubsystemDesc(ASubsystemDescription subsystemDesc) {
        this.subsystemDesc = subsystemDesc;
    }

    public Set<AParameterConfiguration> getParameterConfigurations() {
        return this.unModifiableConfigurations;
    }

    void setParameterConfigurations(Set<AParameterConfiguration> parameterConfigurations) {
        this.parameterConfigurations = parameterConfigurations;
        this.unModifiableConfigurations = Collections.unmodifiableSet(parameterConfigurations);
    }

    public AConfigProfile clone() {
        AConfigProfile res = null;
        try {
            res = (AConfigProfile)super.clone();
            HashSet<AParameterConfiguration> newSet = new HashSet<AParameterConfiguration>();
            for (AParameterConfiguration parmConfig : this.parameterConfigurations) {
                newSet.add(parmConfig.clone());
            }
            res.setParameterConfigurations(newSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return res;
    }

    public long getSubsystemId() {
        return this.subsystemId;
    }

    void setSubsystemId(long subsystemId) {
        this.subsystemId = subsystemId;
    }

    @Override
    public void setBeenInEngineeringMode(boolean beenInEngineeringMode) {
        super.setBeenInEngineeringMode(beenInEngineeringMode);
    }

    @Override
    public void setRemarks(String remarks) {
        super.setRemarks(remarks);
    }

    @Override
    public void mergeProperties(Properties props) {
        if (this.getId() != 0L) {
            throw new ImmutableStateException("no modification of registered data");
        }
        Map<String, ParameterDescription> map = this.subsystemDesc.generateDescriptionMap();
        for (String name : props.stringPropertyNames()) {
            ParameterDescription description = map.get(name);
            if (description == null) continue;
            ParameterConfiguration configuration = this.fetch(description);
            String value = props.getProperty(name);
            if (configuration != null) {
                configuration.modifyValue(value);
                continue;
            }
            AParameterDescription realDescription = (AParameterDescription)description;
            configuration = new AParameterConfiguration(realDescription, value);
            this.addParameterConfigurations(configuration);
        }
    }

    public Set<AParameterDescription> getPossibleParameters() {
        HashSet<AParameterDescription> res = new HashSet<AParameterDescription>();
        for (ParameterDescription parameterDescription : this.getSubsystemDescription().getParamDescriptionSet()) {
            if (parameterDescription.getLevel() > this.getLevel()) continue;
            res.add(new AParameterDescription(parameterDescription));
        }
        return res;
    }

    public void addParameterConfigurations(AParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Parameter Configuration list");
        }
        AParameterConfiguration[] aParameterConfigurationArray = parameterConfigurations;
        int n = parameterConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            AParameterConfiguration parameterConfiguration = aParameterConfigurationArray[n2];
            AParameterDescription description = parameterConfiguration.getParameterDescription();
            if (description.getLevel() > this.getLevel()) {
                throw new IllegalArgumentException("incompatible levels. profile is : " + this.getLevel() + " and description is :" + description.getLevel());
            }
            this.parameterConfigurations.add(parameterConfiguration);
            ++n2;
        }
    }

    @Override
    public void addParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        this.addParameterConfigurations(this.buildSafeArray(parameterConfigurations));
    }

    private AParameterConfiguration[] buildSafeArray(ParameterConfiguration ... parameterConfigurations) {
        AParameterConfiguration[] parms = new AParameterConfiguration[parameterConfigurations.length];
        int ix = 0;
        while (ix < parameterConfigurations.length) {
            ParameterConfiguration conf = parameterConfigurations[ix];
            if (!(conf instanceof AParameterConfiguration)) {
                throw new IllegalArgumentException("deprecated parameter Configuration");
            }
            parms[ix] = (AParameterConfiguration)conf;
            ++ix;
        }
        return parms;
    }

    @Override
    public void removeParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Parameter Configuration list");
        }
        ParameterConfiguration[] parameterConfigurationArray = parameterConfigurations;
        int n = parameterConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterConfiguration parameterConfiguration = parameterConfigurationArray[n2];
            this.parameterConfigurations.remove(parameterConfiguration);
            ++n2;
        }
    }

    @Override
    public ComponentNode getModifiedConfigurationData() {
        ComponentNode res = null;
        ComponentNode componentNode = this.subsystemDesc.getTopComponentNode();
        componentNode = componentNode.clone();
        for (AParameterConfiguration parameterConfiguration : this.getParameterConfigurations()) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            ComponentNode goalComponent = (ComponentNode)componentNode.getNodeByName(componentName);
            Object rawParm = goalComponent.getAttributes().get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked((Object)parameterConfiguration.getValue());
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        res = componentNode;
        return res;
    }
}

