package org.lsst.ccs.startup;

import org.lsst.ccs.framework.*;
import org.lsst.gruth.jutils.ComponentNode;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * the top subsystem that deals with configuration proxy
 * and lookup service
 * @author bamade
 */

public class NodeModularSubsystem extends BasicModularSubSystem {
    private ComponentLookupService lookup;

    public NodeModularSubsystem(String name, ConfigurationProxy proxy) {
        super(name);
        this.configurationProxy = proxy ;
    }

    public void registerNodes(ComponentNode node) {
        this.lookup = new NodeLookup(node) ;
        // HACK because of incoherent trees!
        //TODO remove this hack!
        Iterator<String> iter = node.getAllKeys();
        if (iter != null) {
            while (iter.hasNext()) {
                String key = iter.next();
                Object value = node.getIndirect(key);
                if (value instanceof Module) {
                   // was :  this.registerModule((Module) value);
                    // block left for maintenance purposes
                    this.registerConfigurable(key, (Configurable) value);
                } else if (value instanceof Configurable) {
                    this.registerConfigurable(key, (Configurable) value);
                }
            }
        }
        realRegisterNodes(node);
    }

    //TODO: this cross recursive methods are badly written !!!!
    private void realRegisterNodes(ComponentNode node) {

        // problem about order of evaluation should proceed from the ground up
        ArrayList<ComponentNode> children = node.getChildren();
        if (children != null) {
            for (ComponentNode child : children) {
                realRegisterNodes(child);
                ;
            }
        }
        String key = node.getKey();
        Object value = node.getRealValue();
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable) value;
            configurable.setEnvironment(new Configurable.Environment(key, configurable, configurationProxy, lookup));
            if (value instanceof Module) {
                //this.addModule((Module)value);
                this.rawInitModule((Module) value);
            }
        }
        /*
        Iterator<String> iter = node.getAllKeys() ;
        if (iter != null) {
            while(iter.hasNext()) {
                Object value = node.getIndirect(iter.next()) ;
                if( value instanceof Module) {
                    this.addModule((Module) value);
                }
            }
        } */
    }
}
