package org.lsst.ccs.startup;

import org.lsst.ccs.config.*;
import org.lsst.gruth.jutils.ComponentNode;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Collection;

/**
 * Utility to create locally a Configuration properties file.
 * @author bamade
 */
// Date: 21/06/12

public class LocalDescriptionToConfigurationText {
    public static void main(String[] args) throws Exception {
        if(args.length < 1) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalDescriptionToConfigurationText pathName\n"
                    + " where filename is  xx.ser or xx.groovy or xx.groo\n"
                    + " pathName could be file (with '/' file separator) or resource path");
            System.exit(1);
        }
        String pathName = args[0] ;
        NamesAndTag namesAndTag = BootUtils.namesFromPath(pathName) ;
        InputStream is = BootUtils.getInput(LocalDescriptionToConfigurationText.class, pathName) ;
        SubsystemDescription description ;
        if(pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(is) ;
            ComponentNode componentNode = (ComponentNode) ois.readObject() ;
            description = Factories.createRawSubsystemDescription(namesAndTag.getSubsystemName(), namesAndTag.getTag(),
                    "", "", componentNode, DataFlavour.PURE_OBJECT_TREE);
            ois.close() ;

        } else if(pathName.endsWith(".groovy") || pathName.endsWith(".groo")){
            description = Factories.createRawSubsystemDescription(namesAndTag.getSubsystemName(),
                    namesAndTag.getTag(), "", "", is, "ISO-8859-1") ;

        } else {
            throw new IllegalArgumentException(" not supported : " +pathName) ;
        }

        Collection<ParameterDescription> descriptions = description.getPossibleDescriptions(PackCst.DESIGNER_LEVEL) ;
        description.addParameterDescriptions(descriptions);

        // opening a new File
        namesAndTag.setConfigName("XXXXX");
        String baseName = BootUtils.baseNameFromNames(namesAndTag) ;
        PrintWriter printWriter = new PrintWriter(baseName+".properties", "UTF-8") ;
        description.generateConfigProperties(printWriter, PackCst.DESIGNER_LEVEL);
        printWriter.flush();
        printWriter.close();

    }
}
