package org.lsst.ccs.config.dao.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.lsst.ccs.config.HqlDAO;

import java.util.List;
import java.util.logging.Level;

import static org.lsst.ccs.config.PackCst.CURLOG;

/**
 * @author bamade
 */
// Date: 12/03/13

public class HibernateDAO extends HqlDAO {
    class SessionDelegate implements AbstractSession {
        Session session ;

        SessionDelegate(Session session) {
            this.session = session;
        }

        @Override
        public void save(Object o) throws HibernateException {
             session.save(o);
        }

        @Override
        public void saveOrUpdate(Object o) throws HibernateException {
            session.saveOrUpdate(o);
        }

        @Override
        public void delete(Object o) throws HibernateException {
            session.delete(o);
        }

        @Override
        public void flush() {
            session.flush();
        }

        @Override
        public AbstractQuery createQuery(final String s) {
            return new AbstractQuery() {
                org.hibernate.Query query = session.createQuery(s) ;
                @Override
                public List list() {
                    return query.list() ;
                }
            } ;
        }
    }
    protected SessionFactory sessionFactory;
    org.hibernate.Session session ;
    org.hibernate.Transaction currentTransaction ;
    private boolean exceptionFired ;

    public HibernateDAO() {
        initSession() ;
        session = openSession();
    }

    /*
    dangerous: method to be specialized (to get different service)
     */
    protected void initSession() {
        try {
            /**/
            Configuration configuration = new Configuration().configure() ;
            // Create the SessionFactory from standard (hibernate.cfg.xml)
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().
                    applySettings(configuration.getProperties()).buildServiceRegistry();
            sessionFactory = configuration.buildSessionFactory(serviceRegistry);
            /**/
            //sessionFactory = new AnnotationConfiguration().configure("hibernate.cfg.xml").buildSessionFactory();


            // config file.
        } catch (Throwable ex) {
            // Log the exception.
            CURLOG.log(Level.SEVERE, "Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }
    public  SessionFactory getSessionFactory() {
        return sessionFactory;
    }
    @Override
    public void begin() {
        CURLOG.fine("begin transaction");
        session = getCurrentSession();
        exceptionFired = false ;
        currentTransaction = session.beginTransaction() ;
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void end() {
        // use of wasrollback not sure ...
        CURLOG.fine("end transaction");
        if(!exceptionFired) {
            session.flush();
            currentTransaction.commit() ;
            currentTransaction = null ;
        }
    }

    @Override
    public void fail() {
        if(currentTransaction != null) {
            currentTransaction.rollback();
        }
    }

    @Override
    public void fail(Throwable th) {
        CURLOG.log(Level.SEVERE,"",th);
        fail() ;
    }


    //TODO : write a "pumping" query

    @Override
    public void close() {
        session.close();
        sessionFactory.close();
    }

    protected Session getCurrentSession() {
        Session res = sessionFactory.getCurrentSession() ;
        setSession(new SessionDelegate(res));
        return res;

    }

    protected Session openSession() {
        Session res = sessionFactory.openSession() ;
        setSession(new SessionDelegate(res));
        return res;
    }

}
