package org.lsst.ccs.config;

/**
 * a utility class to document the way types are shown
 * to the end-user (specifically for the configuration properties file)
 * @author bamade
 */
// Date: 03/10/12

public class TypeInfos {

    static String[][] table = {
            {"java.lang.Integer", "integer (example : 6)"}      ,
            {"java.lang.String", "String"}      ,
            {"java.lang.Double", "double (example : 3.0)"}      ,
            {"java.lang.Float", "float (example : 3.0)"}      ,
            {"java.lang.Boolean", "boolean (example : true)"}      ,
            {"[I", "array of integers (example : [1,34,666] )"}      ,
            {"[D", "array of doubles (example : [1.0,34.0,666.66] )"}      ,
            {"[F", "array of floats (example : [1.0,34.0,666.66] )"}      ,
            {"[Ljava.lang.String;", "array of Strings (example : ['hello', 'world'] )"}      ,
            {"org.lsst.gruth.types.GList", "List (example : [23, 34,55])"}      ,
            {"org.lsst.gruth.types.GMap", "Map (example : [length:23, width:44])"}      ,
    } ;
    public static String get(String typeName) {
        String res = typeName ;
        for(String[] keyVal : table) {
            if(keyVal[0].equals(typeName)){
                return keyVal[1] ;
            }
        }
        return res ;
    }
}
