package org.lsst.ccs.config;

import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.nodes.Utils;

import java.io.Serializable;

/**
 * Object to store both a text source for a Subsystem description and the binary data extracted
 * from it (type <TT>ComponentNode</TT>)
 * @author bamade
 */
// Date: 20/06/12


public class TextAndNode  implements Serializable {
    String codeSource;
    ComponentNode componentNode ;

    public TextAndNode(String codeSource, ComponentNode componentNode) {
        this.codeSource = codeSource;
        this.componentNode = componentNode;
    }

    public TextAndNode(Object objSource) {
        if(! (objSource instanceof String)) {
            throw new IllegalArgumentException("TextAndNode ctor accepts String but is " + objSource.getClass()) ;
        }
        String source = (String) objSource;
        ComponentNode node = Utils.getComponentNodeFromGroovy(source) ;
        this.codeSource = source ;
        this.componentNode = node ;
    }


    public String getCodeSource() {
        return codeSource;
    }

     void setCodeSource(String codeSource) {
        this.codeSource = codeSource;
    }

    public ComponentNode getComponentNode() {
        return componentNode;
    }

     void setComponentNode(ComponentNode componentNode) {
        this.componentNode = componentNode;
    }
}
