package org.lsst.ccs.config;

import javax.persistence.Embeddable;
import java.io.Serializable;

/**
 * A data structure that contains name of subsystem, configuration and tag.
 * @author bamade
 */
// Date: 12/04/12

    @Embeddable
public  class NamesAndTag implements Serializable {
        public String subsystemName ;
        public String configName ;
        public String tag ;


        NamesAndTag() {
        }

    public NamesAndTag(String subsystemName, String configName, String tag) {
        this.subsystemName = subsystemName;
        if(configName == null) configName ="" ;
        this.configName = configName;
        if(tag == null) tag ="" ;
        this.tag = tag;
    }

    public String getSubsystemName() {
        return subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        if(configName == null ) configName = "" ;
        this.configName = configName;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        if(tag == null ) tag = "" ;
        this.tag = tag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NamesAndTag that = (NamesAndTag) o;

        if (!configName.equals(that.configName)) return false;
        if (!subsystemName.equals(that.subsystemName)) return false;
        if (!tag.equals(that.tag)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = subsystemName.hashCode();
        result = 31 * result + configName.hashCode();
        result = 31 * result + tag.hashCode();
        return result;
    }

    public String toString() {
        return subsystemName+'_'+configName+'_'+tag ;
    }
}
