package org.lsst.ccs.config;

import org.lsst.ccs.bus.Status;

/**
 * A specific status object that advertises a startup code and tells which
 * data my be required (optionnal).
 * The key value is the address of the sender which is the temporary name of the startup code
 * based on MacAddress.
 * @author bamade
 */
// Date: 26/06/12

public class BootStatus  extends Status {
    private DeploymentDescriptor optionalDescriptor ;
    private String requestedSubsystem;
    private String requestedConfiguration ;
    private String requestedTag ;
    /**
     * used to tell server that this is not a "normal" operation.
     * The database server may decide not to handle this message and let a dummy test server handle it.
     */
    private boolean inTestContext ;

    public BootStatus() {
    }

    public BootStatus(String requestedSubsystem, String requestedConfiguration, String requestedTag) {
        this.requestedSubsystem = requestedSubsystem;
        this.requestedConfiguration = requestedConfiguration;
        this.requestedTag = requestedTag;
    }

    public DeploymentDescriptor getOptionalDescriptor() {
        return optionalDescriptor;
    }

    public void setOptionalDescriptor(DeploymentDescriptor optionalDescriptor) {
        this.optionalDescriptor = optionalDescriptor;
    }

    public String getRequestedSubsystem() {
        return requestedSubsystem;
    }

    public void setRequestedSubsystem(String requestedSubsystem) {
        this.requestedSubsystem = requestedSubsystem;
    }

    public String getRequestedConfiguration() {
        return requestedConfiguration;
    }

    public void setRequestedConfiguration(String requestedConfiguration) {
        this.requestedConfiguration = requestedConfiguration;
    }

    public String getRequestedTag() {
        return requestedTag;
    }

    public void setRequestedTag(String requestedTag) {
        this.requestedTag = requestedTag;
    }

    public boolean isInTestContext() {
        return inTestContext;
    }

    public void setInTestContext(boolean inTestContext) {
        this.inTestContext = inTestContext;
    }

    @Override
    public String getMessageType() {
        return "lsst.bootStatus";
    }

    public String toString() {
        return super.toString() + String.format("%s_%s_%s", this.requestedSubsystem!= null? requestedSubsystem:"",
                this.requestedConfiguration != null? requestedConfiguration : "" ,
                this.requestedTag != null? requestedTag : ""
                ) ;
    }
}
