/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.IOException;
import java.io.InputStream;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.ModularSubsystem;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.utilities.jars.CommonResources;

public class SubsystemBootFromStream {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            SubsystemBootFromStream.usage();
            return;
        }
        String transportProperty = System.getProperty("lsst.messaging.factory");
        if (transportProperty == null) {
            System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        }
        String testContext = System.getProperty("org.lsst.ccs.testcontext", "true");
        System.setProperty("org.lsst.ccs.testcontext", testContext);
        String pathName = args[0];
        if (pathName.endsWith(".xml")) {
            ModularSubsystem.main((String[])args);
        } else {
            String propertiesFileName = null;
            if (args.length > 1) {
                propertiesFileName = args[1];
            }
            Subsystem subsystem = BootUtils.getSubsystemFromFile(pathName, propertiesFileName);
            subsystem.start();
        }
    }

    static InputStream getInput(String pathName) throws IOException {
        return CommonResources.getInput(SubsystemBootFromStream.class, (String)pathName);
    }

    static void usage() {
        System.err.println("usage: java org.lsst.ccs.startup.SubsystemBootfromStream pathName [optionalConfigPropertiesFile]\n where filename is xx.xml or xx.ser or xx.groovy or xx.groo\n pathName could be file (with '/' file separator) or resource path");
    }
}

