package org.lsst.ccs.startup;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.framework.ModularSubsystem;
import org.lsst.ccs.utilities.jars.CommonResources;

import java.io.IOException;
import java.io.InputStream;

/**
 * Boots a subsystem from a local resource.
 * <BR/>
 * <B>Important</B>: if you want this execution to be registered with the configuration system
 * set the <TT>org.lsst.ccs.testcontext</TT> property explicitly to false.
 * By default it is set to true: since you are not requesting a subsystem description from the
 * Configuration service you may be able to register a run of a configuration which is NOT known
 * to the configuration service! (So there are potential bug when you use this property to false: you
 * must be sure that the corresponding configuration is registered -that will not crash the database but some request
 * on historical data will fail-)
 *
 * @author bamade
 */
// Date: 05/06/12

public class SubsystemBootFromStream {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            usage();
            return;
        }
        // defult values
        String userName = "" ;
        String version = "1.0" ;
        int level = PackCst.DESIGNER_LEVEL ;

        String transportProperty = System.getProperty("lsst.messaging.factory");
        if (transportProperty == null) {
            System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        }
        String testContext = System.getProperty("org.lsst.ccs.testcontext", "true");
        System.setProperty("org.lsst.ccs.testcontext", testContext);
        String pathName = args[0];
        if (pathName.endsWith(".xml")) {
            ModularSubsystem.main(args);
        } else {
            /*
             * if there is a second argument it is the configuration file
             * in that case the first argument is only a raw subsystem description without configuration or tag name
            * */
            String propertiesFileName = null;
            if (args.length > 1) {
                propertiesFileName = args[1];
            }

            //boot susbystem
            Subsystem subsystem = BootUtils.getSubsystemFromFile(pathName, propertiesFileName) ;
            subsystem.start();

        }
    }

    static InputStream getInput(String pathName) throws IOException {
        return CommonResources.getInput(SubsystemBootFromStream.class, pathName);
    }

    static void usage() {
        System.err.println("usage: java org.lsst.ccs.startup.SubsystemBootfromStream pathName [optionalConfigPropertiesFile]\n"
                + " where filename is xx.xml or xx.ser or xx.groovy or xx.groo\n"
                + " pathName could be file (with '/' file separator) or resource path");

    }
}
