package org.lsst.ccs.config.utilities;

import org.lsst.ccs.config.NamesAndTag;

/**
 * @author bamade
 */
// Date: 19/06/13

public class ConfigUtils {
    /**
     * gets subsystem name, configName and tag name from pathName
     * @param pathName
     * @return
     */
    public static NamesAndTag namesFromPath(String pathName) {
        //split name
        String subsystemName = "" ;
        String configName = "" ;
        String tag = "" ;
        int indexDot =  pathName.lastIndexOf('.');
        int lastPath = pathName.lastIndexOf('/');
        String rawName = pathName.substring(lastPath + 1, indexDot);
        String[] elements = rawName.split("_");
        //falltrough !
        switch(elements.length) {
            case 3: tag = elements[2] ;
            case 2: configName = elements[1] ;
            case 1: subsystemName = elements[0] ;
        }
        return new NamesAndTag(subsystemName,configName,tag) ;
    }

    /**
     * creates a fileName from a NamesAndTag object (reverse operation of <TT>namesFromPath</TT>
     * @param namesAndTag
     * @return
     */
    public static String baseNameFromNames(NamesAndTag namesAndTag) {
        return String.format("%s_%s_%s", namesAndTag.getSubsystemName(), namesAndTag.getConfigName(),
                namesAndTag.getTag()) ;
    }
}
