package org.lsst.ccs.config;

import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.HollowParm;

import java.io.IOException;
import java.io.PrintWriter;

/**
 * @author bamade
 */
// Date: 04/10/12

public class LocalConfigurationProxy implements ConfigurationProxy {
    private ASubsystemDescription subsystemDescription ;
    /**
     * the reference configuration that is running in normal mode
     */
    private AConfigProfile baseProfile ;
    /**
     * the configuration that is running in engineering/normal mode
     * (in normal mode both configurations are the same)
     */
    private AConfigProfile currentProfile ;

    private boolean inEngineeringMode ;

    private MessagingFactory fac ;

    //TODO : ctors


    public LocalConfigurationProxy(ConfigProfile configProfile) {
        baseProfile = (AConfigProfile) configProfile ;
        subsystemDescription = baseProfile.getSubsystemDesc() ;
    }

    @Override
    public String getConfigurationName() {
        return currentProfile.getName() ;
    }

    @Override
    public String getTagName() {
        return currentProfile.getTag() ;
    }

    @Override
    public synchronized void startNewConfigurationContext() {
        if(inEngineeringMode) {
            throw new IllegalStateException("already in engineering mode") ;
        }
        inEngineeringMode = true ;
        // copy the configProfile and put it in engineering mode
        currentProfile = new AConfigProfile(baseProfile, baseProfile.getName(),
                baseProfile.getTag(), "", PackCst.DESIGNER_LEVEL, true) ;
        // currentProfile = voir factories
    }

    @Override
    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        String strValue ;
        if(value instanceof String){
           strValue = (String)  value ;
        } else {
            strValue = HollowParm.stringify(value) ;
        }
        // check for engineering mode and create new
        if(! inEngineeringMode) {
            startNewConfigurationContext();
        }
        ParameterPath path = new ParameterPath(componentName,"",parameterName);
        ParameterDescription parameterDescription = subsystemDescription.fetch(path) ;
        if(null == parameterDescription) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> "
            + subsystemDescription.getParamDescriptions());
        }
        if(parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
         Object res = parameterDescription.checkValue(strValue) ;
        return new ViewValue(strValue, res) ;
    }

    @Override
    public void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath path = new ParameterPath(componentName,"",parameterName);
        //if static
        currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), value);
    }

    @Override
    public void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath path = new ParameterPath(componentName,"",parameterName);
        String strValue ;
        if( value instanceof String) {
           strValue = (String)  value ;
        } else {
            strValue = HollowParm.stringify(value) ;
        }
        //TODO : warn !!!
        currentProfile.temporaryChangeConfigurationValue(path.toString(), System.currentTimeMillis(), strValue);
    }

    @Override
    public synchronized  void  registerConfiguration(String configurationName, String tagName) throws IOException{
        NamesAndTag namesAndTag = new NamesAndTag(subsystemDescription.getSubsystemName(),
                configurationName,tagName) ;
        // copy from engineering mode to normal
        baseProfile = new AConfigProfile(currentProfile, currentProfile.getName(),
                currentProfile.getTag(), "", PackCst.DESIGNER_LEVEL, false) ;
        currentProfile = baseProfile.clone() ;
        String baseName = ConfigUtils.baseNameFromNames(namesAndTag) ;
        PrintWriter printWriter = new PrintWriter(baseName+".properties", "UTF-8") ;
        currentProfile.generateConfigProperties(printWriter);
        // make subsystem send change!
        inEngineeringMode = false ;
        printWriter.flush() ;
        printWriter.close() ;
    }

    @Override
    public void dropModifications() {
        currentProfile =  baseProfile.clone() ;
        // make subsystem change notification
        inEngineeringMode = false ;
    }

    @Override
    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName,"",parameterName);
        ParameterDescription parameterDescription = subsystemDescription.fetch(path) ;

        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName() ;
        Object res = Constraints.check(type,strValue, null) ;
        return res;
    }

    @Override
    public void setMessagingFactory(MessagingFactory factory) {
        this.fac = factory ;
    }
}
