package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Creates a dummy file-based Configuration database.
 * all history operations are unsupported (as are SQL requests).
 * The numbering scheme for ID are negative values and so can be detected
 *
 * @author bamade
 */
// Date: 14/06/12
/*
implementation:
 - directories: one for description (.groo, .groovy, .ser) other for configuration (.properties)
 other for generated mix(.ser)
 - two local hashMap

 names for descriptions are of the form subsystem__<tag>
 names for configurations and prepared mixes are of the form subsystem_configuration_<tag>

 when saved in files the description/parameterDescription are stripped of their id!


    */


public class FIleBasedDAO  implements DBInterface{
    long seed = - System.currentTimeMillis();
    long idForSubsystems = seed;
    long idForDescriptions = seed ;
    long idForProfiles = seed ;
    long idForParmConfig = seed ;

    Map<String,SubsystemDescription> descriptionMap = new HashMap<String, SubsystemDescription>() ;

    Map<String,ConfigProfile> configProfileMap = new HashMap<String, ConfigProfile>() ;

    Logger CURLOG = Logger.getLogger("org.lsst.ccs.config.FIlebasedDAO") ;

    public FIleBasedDAO() {
        // reads the file in a directory
        //prepares the way data is saved .... should be done by a facade client
        //  shutdown hook should calls close() if not called
    }

    /**
     * dummy constructor used by MemoryDAO
     * @param notFromFile
     */
    public FIleBasedDAO( boolean notFromFile) {
    }

    @Override
    public void begin() {
        //
    }

    @Override
    public void end() {
    }

    @Override
    public void fail() {
        // log
    }

    @Override
    public void fail(Throwable th) {
        CURLOG.log(Level.SEVERE, "file DAO" , th) ;
        // log
    }

    @Override
    public void saveSubsystemDescription(ASubsystemDescription newDescription) {
       //TODO
        String subsystemName = newDescription.getSubsystemName() ;
        String tag = newDescription.getTag() ;
        newDescription.setId(idForSubsystems++);
        for(AParameterDescription parameterDescription : newDescription.getParamDescriptions()) {
            parameterDescription.setId(idForDescriptions++);
        }
        descriptionMap.put(subsystemName+"__"+tag, newDescription) ;
    }

    @Override
    public void saveGhostDescriptions(GhostSubsystemDescription ghosts) {
        String subsystemName = ghosts.getSubsystemName() ;
        String tag = ghosts.getTag() ;
        descriptionMap.put("#"+ subsystemName+"__"+tag, ghosts) ;
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) {
        return (ASubsystemDescription) descriptionMap.get(name+"__"+tag);  //ToDO
    }

    @Override
    public ASubsystemDescription getActiveSubsystemDescription(long id) {
        for(String key : descriptionMap.keySet()) {
            if(! key.startsWith("#")) {
                SubsystemDescription description = descriptionMap.get(key)  ;
                if(description.getId() == id) {
                    return (ASubsystemDescription) description ;
                }
            }
        }
        return null;
    }

    @Override
    public GhostSubsystemDescription getGhostDescription(long id) {
        for(String key : descriptionMap.keySet()) {
            if(key.startsWith("#")) {
                SubsystemDescription description = descriptionMap.get(key)  ;
                if(description.getId() == id) {
                    return (GhostSubsystemDescription) description ;
                }
            }
        }
        return null;
    }


    @Override
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) {
        String key = oldDescription.getSubsystemName()+"__"+ oldDescription.getTag() ;
        descriptionMap.remove(key) ;
    }

    @Override
    public void saveConfigProfile(AConfigProfile newProfile) {
        //
        String key = "_"+newProfile.getName()+"_"+newProfile.getTag() ;
        newProfile.setId(idForProfiles++);
        for(AParameterConfiguration configuration : newProfile.getParameterConfigurations()) {
            configuration.setId(idForParmConfig++);
        }
        configProfileMap.put(key, newProfile) ;
    }

    @Override
    public void savePastProfile(PastConfigProfile deprecatedProfile) {
        String key = "#" + "_"+
                deprecatedProfile.getName()+"_"+deprecatedProfile.getTag() ;
        configProfileMap.put(key, deprecatedProfile) ;
    }

    @Override
    public AConfigProfile getActiveConfigProfile(String name, String tag) {
        return (AConfigProfile) configProfileMap.get("_"+name+"_"+tag);
    }

    @Override
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) {
        String key = "_"+
                oldProfile.getName()+"_"+oldProfile.getTag() ;
        configProfileMap.remove(key) ;
    }

    @Override
    public void modifyParmConfig(AParameterConfiguration config) {
        //searches for the parm in configProfile Map
        // use fetch + id comparison
        // then modifies it ? HOW?
        //not implemented
        //TODO
        CURLOG.log(Level.WARNING, "file DAO: engineering mode not implemented" ) ;
    }

    @Override
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description) {
        ArrayList<AConfigProfile> res = new ArrayList<AConfigProfile>() ;
        long requestedId = description.getId() ;
        for(String key : configProfileMap.keySet()) {
            if(! key.startsWith("#")) {
                ConfigProfile profile = configProfileMap.get(key)  ;
                if(profile.getSubsystemDescription().getId() == requestedId) {
                    res.add((AConfigProfile)profile) ;
                }
            }
        }
        return res;
    }

    @Override
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) {
        ArrayList<PastConfigProfile> res = new ArrayList<PastConfigProfile>() ;
        long requestedId = description.getId() ;
        for(String key : configProfileMap.keySet()) {
            if(key.startsWith("#")) {
                ConfigProfile profile = configProfileMap.get(key)  ;
                if(profile.getSubsystemDescription().getId() == requestedId) {
                    res.add((PastConfigProfile)profile) ;
                }
            }
        }
        return res;
    }

    @Override
    public void saveRun(RunHistory runHistory) {
        CURLOG.log(Level.WARNING, "file DAO: run history not implemented" ) ;
        //Log
    }

    @Override
    public void savePreparedConfiguration(PreparedConfiguration preparedConfiguration) {
        //todo : do it!and save the corresponding file
        CURLOG.log(Level.WARNING, "file DAO: prepared configuration not implemented" ) ;

    }

    @Override
    public PreparedConfiguration getPreparedConfiguration(String subsystemName, String configName, String tag) {
        //todo : do it!
        CURLOG.log(Level.WARNING, "file DAO: prepared configuration not implemented" ) ;
        return null;
    }

    @Override
    public void saveMachineConfiguration(MachineConfiguration machineConfiguration) {
        CURLOG.log(Level.WARNING, "file DAO: machine configuration not implemented" ) ;

    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) {
        CURLOG.log(Level.WARNING, "file DAO: machine configuration not implemented" ) ;
        return null;
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) {
        CURLOG.log(Level.WARNING, "file DAO: hql not implemented" ) ;
        return Collections.emptyList();
    }

    @Override
    public void close() {
        // todo saves in files
    }
}
