package org.lsst.ccs.config.remote.scripts;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;

import java.io.Closeable;
import java.io.IOException;

/**
 * operates on Buses and send commands to the configuration service , receives responses
 * @author bamade
 */
// Date: 18/07/12

public class ConfigurationBusClient implements Closeable {
    String serverName ;
    MessagingFactory fac ;
    SynchronousCommandAgent dispenser ;
    public static long TIME_OUT = 10000 ;

    public ConfigurationBusClient(String serverName, String clientName) {
        this.serverName = serverName;
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        fac = MessagingFactory.getInstance().forSubsystem(clientName) ;
        dispenser = new SynchronousCommandAgent(fac) ;
    }

    public ConfigurationBusClient() {
        this("configServer", "client[" + Subsystem.getEthHardAddress()+"]") ;
    }

    /**
     * Invokes a method remotely on the Configuration service server.
     * The call is synchronous: it waits for a response or fails on time out
     * @param timeout if negative the command is ssent asynchronously
     * @param methodName
     * @param args
     * @return the result of the remote call or null is command is asynchronous
     * @throws Exception can be the result of remote execution or timeout
     */
    public Object invoke(long timeout, String methodName, Object... args) throws Exception {
        ModuleInvokerCommand command = new ModuleInvokerCommand(methodName, args) ;
        command.setDestination(serverName);
        if(timeout< 0) {
            fac.sendCommand(command);
            return null ;
        } else {
            return dispenser.invoke(command,timeout ) ;
        }
    }

    /**
     * Invokes a method remotely on the Configuration service server.
     * The call is synchronous: it waits for a response or fails on time out (which is of 10 seconds).
     * @param methodName
     * @param args
     * @return
     * @throws Exception can be the result of remote execution or timeout
     */
    public Object invoke(String methodName, Object... args) throws Exception {
        return invoke(TIME_OUT, methodName, args) ;
    }

    @Override
    public void close() throws IOException {
        fac.shutdownBusAccess();
    }
}
