package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.SubsystemDescription;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A data structure that groups the results of a subsystem description registration.
 * Contains:
 * <UL>
 *     <LI/> a registered susbsystem description
 *     <LI/> a possible descriptionDeprecation Event
 *     <LI/> a list of possible deprecated <TT>ConfigProfiles</TT> that were referencing the deprecated
 *     subsystem description.
 * </UL>
 * @author bamade
 */
// Date: 06/06/12

public class DescriptionResult implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 6532563372505137863L;
	SubsystemDescription result ;
    //TODO ! may not be necessarya (if ghost registered in event!)
    DescriptionDeprecationEvent  descriptionDeprecationEvent ;
    List<ProfileDeprecationEvent> profileDeprecationEvents = new ArrayList<ProfileDeprecationEvent>();
    List<ProfileDeprecationEvent> publicList = Collections.unmodifiableList(profileDeprecationEvents) ;
    public DescriptionResult() {
    }

    public SubsystemDescription getResult() {
        return result;
    }

    void setResult(SubsystemDescription result) {
        this.result = result;
    }

    public DescriptionDeprecationEvent getDescriptionDeprecationEvent() {
        return descriptionDeprecationEvent;
    }

    void setDescriptionDeprecationEvent(DescriptionDeprecationEvent descriptionDeprecationEvent) {
        this.descriptionDeprecationEvent = descriptionDeprecationEvent;
    }

    void addProfileDeprecationEvent(ProfileDeprecationEvent event){
        profileDeprecationEvents.add(event) ;
    }

    public List<ProfileDeprecationEvent> getProfileDeprecationEvents() {
        return publicList ;
    }
}
