package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.ConfigProfile;

import java.io.Serializable;

/**
 * Notification of a ConfigProfile Deprecation.
 * <BR/>
 * WARNING: the <TT>ConfigProfile</TT> data may be changed in future releases
 * @author bamade
 */
// Date: 06/06/12

public class ProfileDeprecationEvent implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = -3148379924994636493L;
	public final ConfigProfile deprecating ;
    public final String detail ;
    public final long stamp = System.currentTimeMillis() ;

    public ProfileDeprecationEvent(ConfigProfile deprecating, String detail) {
        this.deprecating = deprecating;
        this.detail = detail;
    }
}
