/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote.scripts;

import java.io.Closeable;
import java.io.IOException;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;

public class ConfigurationBusClient
implements Closeable {
    private final String serverName;
    private final AgentMessagingLayer messagingAccess;
    private final SynchronousCommandAgent dispenser;
    public static long TIME_OUT = 10000L;

    public ConfigurationBusClient(String serverName, Agent agent) {
        this.serverName = serverName;
        this.messagingAccess = agent.getMessagingAccess();
        this.dispenser = new SynchronousCommandAgent(this.messagingAccess);
    }

    private ConfigurationBusClient(String serverName) {
        this(serverName, new Agent(serverName, AgentInfo.AgentType.SERVICE));
    }

    public ConfigurationBusClient() {
        this("configServer");
    }

    public Object invoke(long timeout, String methodName, Object ... args) throws Exception {
        CommandRequest command = new CommandRequest(this.serverName, methodName, args);
        if (timeout < 0L) {
            this.messagingAccess.sendCommandRequest(command, null);
            return null;
        }
        return this.dispenser.invoke(command, timeout);
    }

    public Object invoke(String methodName, Object ... args) throws Exception {
        return this.invoke(TIME_OUT, methodName, args);
    }

    @Override
    public void close() throws IOException {
    }
}

