package org.lsst.ccs.config.remote.scripts;

import java.util.Map;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.utilities.ConfigUtils;

/**
 * registers a ConfigProfile saved in a .properties file to the remote Configuration service (using the buses).
 * @author bamade
 */
// Date: 19/07/12

public class RegisterConfigurationFromFile {
    ConfigurationBusClient busClient ;

    public RegisterConfigurationFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public ProfileResult register(SubsystemDescription description, String categoryName, String configName, String userName, int level) throws Exception {
        LocalConfigurationProxy configurationProxy = new LocalConfigurationProxy(description);
        Map<String,String> taggedCategories = ConfigUtils.parseConfigurationString(description.getCategorySet(),categoryName+":"+configName);
        configurationProxy.loadCategories(taggedCategories);

        ConfigProfile profile = configurationProxy.getProfileForCat(categoryName);
        // remotely registers it
        Object res = busClient.invoke("registerConfigProfile", profile) ;
        // return result
        return (ProfileResult) res ;
    }
}
