package org.lsst.ccs.config.remote.scripts;

import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;

import java.io.Closeable;
import java.io.IOException;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;

/**
 * operates on Buses and send commands to the configuration service , receives responses
 * @author bamade
 */
// Date: 18/07/12

public class ConfigurationBusClient implements Closeable {
    
    private final String serverName ;
    private final AgentMessagingLayer messagingAccess ;
    private final SynchronousCommandAgent dispenser ;
    public static long TIME_OUT = 10000 ;

    public ConfigurationBusClient(String serverName, Agent agent) {
        this.serverName = serverName;
        this.messagingAccess = agent.getMessagingAccess();
        dispenser = new SynchronousCommandAgent(this.messagingAccess) ;
    }

    private ConfigurationBusClient(String serverName) {
        this(serverName,new Agent(serverName, AgentInfo.AgentType.SERVICE));
    }

    public ConfigurationBusClient() {
        this("configServer") ;
    }

    /**
     * Invokes a method remotely on the Configuration service server.
     * The call is synchronous: it waits for a response or fails on time out
     * @param timeout if negative the command is ssent asynchronously
     * @param methodName
     * @param args
     * @return the result of the remote call or null is command is asynchronous
     * @throws Exception can be the result of remote execution or timeout
     */
    public Object invoke(long timeout, String methodName, Object... args) throws Exception {
        CommandRequest command = new CommandRequest(serverName, methodName, args);
        if(timeout< 0) {
            messagingAccess.sendCommandRequest(command, null);
            return null ;
        } else {
            return dispenser.invoke(command,timeout ) ;
        }
    }

    /**
     * Invokes a method remotely on the Configuration service server.
     * The call is synchronous: it waits for a response or fails on time out (which is of 10 seconds).
     * @param methodName
     * @param args
     * @return
     * @throws Exception can be the result of remote execution or timeout
     */
    public Object invoke(String methodName, Object... args) throws Exception {
        return invoke(TIME_OUT, methodName, args) ;
    }

    @Override
    public void close() throws IOException {
//        messagingAccess.shutdownBusAccess();
    }
}
