package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.SubsystemDescription;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Properties;

/**
 * A RMI server for Configuration service that delegates to a local
 * <TT>ConfigurationServiceImpl</TT> object.
 * @author bamade
 */
// Date: 06/06/12

public class RMIConfigurationServer extends UnicastRemoteObject
        implements ConfigurationService {
    ConfigurationService configurationService ;

    public RMIConfigurationServer(ConfigurationService impl) throws RemoteException {
        this.configurationService = impl ;
    }

    @Override
    public DescriptionResult registerSubsystemDescription(SubsystemDescription newDescription) throws RemoteException {
        return configurationService.registerSubsystemDescription(newDescription);
    }

    @Override
    public DescriptionResult deprecateSubsystemDescription(String subsystemName, String tag) throws RemoteException {
        return configurationService.deprecateSubsystemDescription(subsystemName, tag);
    }

    @Override
    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws RemoteException {
        return configurationService.getActiveSubsystemDescription(name, tag) ;
    }

    @Override
    public ProfileResult registerConfigProfile(ConfigProfile newProfile) throws RemoteException {
        return configurationService.registerConfigProfile(newProfile);
    }

    @Override
    public ProfileResult registerConfiguration(String subsystemName, String configurationName, String tag,
                                               String user, int level , Properties props) throws RemoteException{
        return configurationService.registerConfiguration(subsystemName,configurationName,tag,user,level,props) ;
    }
    @Override
    public ProfileResult deprecateConfigProfile(String subsystemName,String name, String tag) throws RemoteException {
        return configurationService.deprecateConfigProfile(subsystemName, name, tag);
    }

    @Override
    public ConfigProfile getActiveConfigProfile(String subsystemName, String name, String tag) throws RemoteException {
        return configurationService.getActiveConfigProfile(subsystemName, name,tag) ;
    }

    @Override
    public ParameterConfiguration modifyParmConf(ParameterConfiguration engineeringModeParm) throws RemoteException {
        return configurationService.modifyParmConf(engineeringModeParm);
    }

    @Override
    public ConfigProfile getConfigRunningAt(String subsystemName, long date) throws RemoteException {
        return configurationService.getConfigRunningAt(subsystemName, date);
    }

    @Override
    public String getActiveValueAt(String subsystemName, String parameterPath, long date) throws RemoteException {
        return configurationService.getActiveValueAt(subsystemName,parameterPath,date);
    }


    @Override
    public ConfigProfile getConfigValidAt(String subsystemName, String name, String tag, long date) throws RemoteException {
        return configurationService.getConfigValidAt(subsystemName, name, tag, date);
    }

    @Override
    public String getValueValidAt(String subsystemName, String profileName, String profileTag, String parameterPath, long date) throws RemoteException {
        return configurationService.getValueValidAt(subsystemName, profileName, profileTag, parameterPath, date);
    }

    @Override
    public ConfigProfile getPrevious(ConfigProfile current) throws RemoteException {
        return configurationService.getPrevious(current);
    }

    @Override
    public ConfigProfile getNext(ConfigProfile current) throws RemoteException {
        return configurationService.getNext(current);
    }

    @Override
    public SubsystemDescription getPrevious(SubsystemDescription current) throws RemoteException {
        return configurationService.getPrevious(current);
    }

    @Override
    public void createPreparedConfiguration(String subsystemName, String configName, String tag, String user) throws RemoteException {
        configurationService.createPreparedConfiguration(subsystemName,configName,tag,user);
    }

    @Override
    public void registerMachineConfiguration(MachineConfiguration machineConfiguration) throws RemoteException {
        configurationService.registerMachineConfiguration(machineConfiguration);
    }

    @Override
    public MachineConfiguration getMachineConfiguration(String macAddress) throws RemoteException {
        return configurationService.getMachineConfiguration(macAddress) ;
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) throws RemoteException {
        return configurationService.simpleHQLRequest(hqlString);
    }
}
