package org.lsst.ccs.config.remote;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.*;
import org.lsst.ccs.framework.BasicModularSubSystem;

import java.util.logging.Level;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * A subsystem that listens on the buses for request for boot data, or for other subsystems
 * status notifications fired when they start with a configuration (or give up);
 * it is also a full-fledged Configuration service that can receive and execute commands.
 * <p/>
 * The system property "org.lsst.ccs.testcontext" tells the server if it is only in test context.
 * In that case it will handle only boot requests that are in test context (property <TT>inTestContext</TT>:
 * this can be used to create a "dummy" file based server that handles tests.
 *
 * @author bamade
 */
// Date: 26/06/12

public class ConfigurationServerSystem extends BasicModularSubSystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    boolean forTestsOnly;

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer");
        this.facade = facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext","false");
        forTestsOnly = "true".equals(testContext.toLowerCase());
        this.service = new ConfigurationServiceImpl(facade);
        // add module main as ConfigurationserverModule
        this.addModule(new ConfigurationServerModule(service));
        getMessagingAccess().addStatusMessageListener(bootStatusListener);
    }

    private final StatusMessageListener bootStatusListener = (StatusMessage s) -> {
        String initiatorName = s.getOriginAgentInfo().getName();
        //if bootStatus
        try {
//            if (s instanceof BootStatus) {
//                // beware: initiator is not a subsystem
//                BootStatus bootStatus = (BootStatus) s;
//                // call appropriate method
//                String requestedSubsystem = bootStatus.getRequestedSubsystem();
//                String requestedConfiguration = bootStatus.getRequestedConfiguration();
//                String requestedTag = bootStatus.getRequestedTag();
//                String origin = bootStatus.getOriginAgentInfo().getName();
//                boolean forTestContext = bootStatus.isInTestContext();
//                // the server is not for test AND the message is not for Test
//                // OR the server is for test AND the message is for Test
//                if (!(forTestsOnly ^ forTestContext)) {
//                    Object startupObject = null;
//                    BootCommand cmd = null;
//                    if (requestedSubsystem != null && !"".equals(requestedSubsystem)) {
//
//                    } else {
//                        // based on machineConfiguration
//                        MachineConfiguration machineConfiguration = facade.getMachineConfiguration(origin);
//                        requestedSubsystem = machineConfiguration.getSubsystemName() ;
//                        requestedConfiguration = machineConfiguration.getConfigName() ;
//                        requestedTag = machineConfiguration.getTag() ;
//                    }
//                    // facade request for active combination
//                    //if configuration send configuration
//                    if(requestedConfiguration!= null && ! "".equals(requestedConfiguration)) {
//                        startupObject = facade.getActiveConfigProfile(requestedSubsystem, requestedConfiguration, requestedTag) ;
//                    } else {
//                        // else if description send description only
//                        startupObject = facade.getActiveSubsystemDescription(requestedSubsystem, requestedTag);
//                    }
//                    cmd = new BootCommand(origin, requestedSubsystem, requestedConfiguration, requestedTag, startupObject);
//                    // and send Command
//                    if (cmd != null) {
//                        //getMessagingAccess().sendCommand(cmd);
//                    } else {
//                        PackCst.CURLOG.log(Level.WARNING, "no descriptions for ", s);
//                        //TODO :tell subsystem startup we are in error!
//                    }
//                }
//
//                //
//            } 
//            else if (s instanceof StatusForStart) {
//                StatusForStart startStatus = (StatusForStart) s;
//                //TODO: this is a patch due to the fact this is a subsystem: modify!
//                if(startStatus.getOriginAgentInfo().getName().equals(getName())) {
//                    return ;
//                }
//                boolean forTestContext = startStatus.isInTestContext();
//                if (!(forTestsOnly ^ forTestContext)) {
//                    facade.registerRun(initiatorName, startStatus.getConfigurationName(),
//                            startStatus.getTag(), s.getTimeStamp());
//                    //register RUN
//                }
//            } else if (s instanceof StatusForEnd) {
//                //register end run
//                StatusForEnd endStatus = (StatusForEnd) s;
//                //TODO: this is a patch due to the fact this is a subsystem: modify!
//                if(endStatus.getOriginAgentInfo().getName().equals(getName())) {
//                    return ;
//                }
//                boolean forTestContext = endStatus.isInTestContext();
//                if (!(forTestsOnly ^ forTestContext)) {
//                    facade.endRun(initiatorName, endStatus.getConfigurationName(),
//                            endStatus.getTag(), endStatus.getTimeStamp());
//                }
//            }
        } catch (Exception exc) {
            PackCst.CURLOG.log(Level.SEVERE, "on status message " + s, exc);
            System.err.println("ERROR :" + exc);
        }
    };

    public static void main(String[] args) throws Exception{
        ConfigurationFacade facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext","false");
        if ( "true".equals(testContext.toLowerCase())) {
            facade = new ConfigurationFacade(new FIleBasedDAO());
        } else {
            String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
            DBInterface dao = (DBInterface) Class.forName(clazzName).newInstance() ;
            facade = new ConfigurationFacade(dao);
        }
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
        system.stayAlive() ;
    }
}
