package org.lsst.ccs.config.remote.scripts;

import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.nodes.Utils;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;

/**
 * gets description data from a file and registers it to the remote configuration service (on top of command bus).
 * @author bamade
 */
// Date: 19/07/12

    //TODO: fix modularity problems with dependencies to startup package

public class RegisterDescriptionFromFile {
    ConfigurationBusClient busClient  ;

    public RegisterDescriptionFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public RegisterDescriptionFromFile() {
        busClient = new ConfigurationBusClient() ;
    }

    public DescriptionResult register(String pathName, String user, String version) throws Exception {
        //todo: code duplication from SubsystemBootfromStream -> move to utility code
        ComponentNode componentNode = null ;
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath(pathName) ;
        //split name
        String subsystemName = namesAndTag.getSubsystemName() ;
        String configName = namesAndTag.getConfigName() ;
        String tag = namesAndTag.getTag() ;
        InputStream is = CommonResources.getInput(RegisterDescriptionFromFile.class, pathName) ;
        if(pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (ComponentNode) ois.readObject();

        } else if( pathName.endsWith(".groovy") || pathName.endsWith(".groo")){
            //TODO: handle the encoding!
            componentNode = Utils.getComponentNodeFromGroovy(is, "ISO-8859-1");
        }
        // end duplication

        SubsystemDescription description = Factories.createSubsystemDescription(subsystemName,tag, user, version,
                componentNode, DataFlavour.PURE_OBJECT_TREE, SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
        // creates a SubsystemDescription
        Object res = busClient.invoke("registerSubsystemDescription", description) ;

        // remotely registers it and returns the result
        return (DescriptionResult) res ;
    }
}
