package org.lsst.ccs.config.remote.scripts;

import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.utilities.jars.CommonResources;

import java.io.InputStream;
import java.util.Properties;

/**
 * registers a ConfigProfile saved in a .properties file to the remote Configuration service (using the buses).
 * @author bamade
 */
// Date: 19/07/12

public class RegisterConfigurationFromFile {
    ConfigurationBusClient busClient ;

    public RegisterConfigurationFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public RegisterConfigurationFromFile() {
        busClient = new ConfigurationBusClient() ;
    }

    public ProfileResult register(SubsystemDescription description, String pathName, String userName, int level) throws Exception {
        //gets a file
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath(pathName) ;
        //split name
        String subsystemName = namesAndTag.getSubsystemName() ;
        if(! subsystemName.equals(description.getSubsystemName())) {
            throw new IllegalArgumentException( subsystemName + "not coherent with " +
                    description.getSubsystemName()  ) ;
        }
        String configName = namesAndTag.getConfigName() ;
        String tag = namesAndTag.getTag() ;
        InputStream is = CommonResources.getInput(RegisterConfigurationFromFile.class, pathName) ;
        // populates a Properties
        Properties properties = new Properties() ;
        properties.load(is);
        // creates a raw configProfile
        ConfigProfile profile = Factories.createRawConfigProfile(description, configName, tag, userName, level) ;
        // modifies the configProfile
        profile.mergeProperties(properties);
        // remotely registers it
        Object res = busClient.invoke("registerConfigProfile", profile) ;
        // return result
        return (ProfileResult) res ;


    }
}
