/*
 * Decompiled with CFR 0.152.
 */
package hibernate_tests;

import java.io.Serializable;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.dao.hibernate.HibernateDAO;

public class TztTiming {
    public static void main(String[] args) throws Exception {
        HibernateDAO dao = new HibernateDAO();
        ConfigurationFacade facade = new ConfigurationFacade((DBInterface)dao);
        facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                System.out.println(".........deprecating subsystem description : " + description);
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                System.out.println(".........deprecating config profile : " + profile);
            }
        });
        SubsystemDescription subsystemDescription = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (Serializable)((Object)"dummy string"));
        System.out.println("---> registering a subsystem");
        facade.registerSubsystemDescription(subsystemDescription, new ConfigurationFacade.Profiles());
        System.out.println("created subsystem description  : " + subsystemDescription);
        long oldID = subsystemDescription.getId();
        System.out.println("---> registering a profile");
        ConfigProfile profile1 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"", (String)"profile1");
        facade.registerConfigProfile(profile1);
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        System.out.println("Sleeping ....");
        Thread.sleep(1000L);
        long date = System.currentTimeMillis();
        Thread.sleep(1000L);
        System.out.println("---> registering same profile");
        ConfigProfile profile2 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"", (String)"profile1");
        System.out.println(" registered profile :" + profile2);
        facade.registerConfigProfile(profile2);
        System.out.println("---> getting previous  profile");
        ConfigProfile previous = facade.getPrevious(profile2);
        System.out.println(" previous registered profile :" + previous);
        System.out.println("---> getting next  profile");
        ConfigProfile next = facade.getNext(previous);
        System.out.println(" next registered profile :" + next);
        System.out.println("---> getting  a profile at a date");
        ConfigProfile when = facade.getConfigValidAt("mySubsystem", "profile1", "tag", date);
        System.out.println(" at date registered profile :" + when);
    }
}

