/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.dao.hibernate;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.lsst.ccs.config.HqlDAO;
import org.lsst.ccs.config.PackCst;

public class HibernateDAO
extends HqlDAO {
    protected SessionFactory sessionFactory;
    Session session;
    Transaction currentTransaction;
    private boolean exceptionFired;

    public HibernateDAO() {
        this(null);
    }

    public HibernateDAO(String resource) {
        this.initSession(resource);
        this.session = this.openSession();
    }

    protected void initSession(String resource) {
        try {
            Configuration configuration = resource == null ? new Configuration().configure() : new Configuration().configure(resource);
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).buildServiceRegistry();
            this.sessionFactory = configuration.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable ex) {
            PackCst.CURLOG.log(Level.SEVERE, "Initial SessionFactory creation failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void begin() {
        PackCst.CURLOG.fine((Object)"begin transaction");
        this.session = this.getCurrentSession();
        this.exceptionFired = false;
        this.currentTransaction = this.session.beginTransaction();
    }

    public void end() {
        PackCst.CURLOG.fine((Object)"end transaction");
        if (!this.exceptionFired) {
            this.session.flush();
            this.currentTransaction.commit();
            this.currentTransaction = null;
        }
    }

    public void fail() {
        if (this.currentTransaction != null) {
            this.currentTransaction.rollback();
        }
    }

    public void fail(Throwable th) {
        PackCst.CURLOG.log(Level.SEVERE, "", th);
        this.fail();
    }

    public void close() {
        this.session.close();
        this.sessionFactory.close();
    }

    protected Session getCurrentSession() {
        Session res = this.sessionFactory.getCurrentSession();
        this.setSession(new SessionDelegate(res));
        return res;
    }

    protected Session openSession() {
        Session res = this.sessionFactory.openSession();
        this.setSession(new SessionDelegate(res));
        return res;
    }

    public List dumpTable(String table) {
        this.begin();
        List res = this.session.createSQLQuery("Select * from " + table).list();
        this.close();
        return res;
    }

    class SessionDelegate
    implements HqlDAO.AbstractSession {
        Session session;

        SessionDelegate(Session session) {
            this.session = session;
        }

        public void save(Object o) throws HibernateException {
            this.session.save(o);
        }

        public void saveOrUpdate(Object o) throws HibernateException {
            this.session.saveOrUpdate(o);
        }

        public void delete(Object o) throws HibernateException {
            this.session.delete(o);
        }

        public void flush() {
            this.session.flush();
        }

        public HqlDAO.AbstractQuery createQuery(String s) {
            return new HqlDAO.AbstractQuery(s){
                Query query;
                {
                    this.query = SessionDelegate.this.session.createQuery(string);
                }

                public List list() {
                    return this.query.list();
                }
            };
        }
    }
}

