/*
 * Decompiled with CFR 0.152.
 */
package hibernate_tests;

import java.io.Serializable;
import java.util.Date;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.dao.hibernate.HibernateDAO;

public class TztEngineeringMode1 {
    public static void main(String[] args) throws Exception {
        HibernateDAO dao = new HibernateDAO();
        ConfigurationFacade facade = new ConfigurationFacade((DBInterface)dao);
        facade.setDeprecationListener(new DeprecationListener(){

            public void subsystemDeprecating(SubsystemDescription description) {
                System.out.println(".........deprecating subsystem description : " + description);
            }

            public void configProfileDeprecating(ConfigProfile profile) {
                System.out.println(".........deprecating config profile : " + profile);
            }
        });
        SubsystemDescription subsystemDescription = Factories.createRawSubsystemDescription((String)"mySubsystem", (String)"", (String)"smith", (String)"1.0", (Serializable)((Object)"dummy string"), (DataFlavour)DataFlavour.DUMMY_TEXT);
        ParameterBase base2 = new ParameterBase("component", "", "param2", "java.lang.Integer", "100");
        ParameterBase base3 = new ParameterBase("component", "", "param3", "java.lang.Double", "-0.1");
        ParameterDescription description2 = Factories.createParameterDescription((ParameterBase)base2, (String)"descr", (String)"p2", (String)"", (int)5);
        ParameterDescription description3 = Factories.createParameterDescription((ParameterBase)base3, (String)"descr", (String)"p3", (String)"", (int)5);
        subsystemDescription.addParameterDescriptions(new ParameterDescription[]{description2, description3});
        System.out.println("---> registering a subsystem");
        facade.registerSubsystemDescription(subsystemDescription);
        ConfigProfile profile1 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescription, (String)"profile1", (String)"tag", (String)"smith", (int)5);
        ParameterConfiguration config2 = Factories.createParameterConfiguration((ParameterDescription)description2, (String)"200");
        ParameterConfiguration config3 = Factories.createParameterConfiguration((ParameterDescription)description3, (String)"0.1");
        profile1.addParameterConfigurations(new ParameterConfiguration[]{config2, config3});
        facade.registerConfigProfile(profile1);
        System.out.println(" registered profile :" + profile1 + " --> " + profile1.getSubsystemDescription());
        facade.registerRun("mySubsystem", "profile1", "tag", System.currentTimeMillis());
        ConfigProfile engProfile = Factories.copyProfile((ConfigProfile)profile1, (String)"engProfile1", (String)"abel", (int)5, (boolean)true);
        facade.registerConfigProfile(engProfile);
        facade.registerRun("mySubsystem", "engProfile1", "engineering", System.currentTimeMillis());
        Thread.sleep(5L);
        engProfile.temporaryChangeConfigurationValue(config2, System.currentTimeMillis(), "300", false);
        Thread.sleep(10L);
        long time = System.currentTimeMillis();
        System.out.println("TIME -> " + time);
        Thread.sleep(10L);
        engProfile.temporaryChangeConfigurationValue(config2, System.currentTimeMillis(), "400", false);
        ConfigProfile taggedVersion = Factories.copyProfile((ConfigProfile)engProfile, (String)"high wind", (String)"abel", (int)5, (boolean)false);
        facade.registerConfigProfile(taggedVersion);
        facade.registerRun("mySubsystem", "profile2", "high wind", System.currentTimeMillis());
        ParameterConfiguration config2B = taggedVersion.fetch((PathObject)base2);
        System.out.println("modified value should be 400 : " + config2B.getValue());
        System.out.println(" engineering profile" + engProfile);
        System.out.println(" new tagged profile" + taggedVersion);
        ConfigProfile running = facade.getConfigRunningAt("mySubsystem", time);
        if (running != null) {
            String aVal = running.getValueAt("component//param2", time);
            System.out.println("at " + new Date(time) + "value was " + aVal);
        } else {
            System.out.println("value not found");
        }
    }
}

