/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class CategoryTagTest
extends CcsTestCaseTemplate {
    @Test
    public void testDefaultCategoryTag() throws Exception {
        CategoryDescription tag99 = CategoryDescription.parseCategoryTagInput((String)"timers:defaultInitial(d=107)");
        SingleCategoryTag timersTag = (SingleCategoryTag)tag99.getSingleCategoryTags().get(0);
        Assert.assertEquals((Object)"d", (Object)timersTag.getRequestedVersion());
        Assert.assertEquals((Object)"107", (Object)timersTag.getResolvedVersion());
        SingleCategoryTag sourcedTag = new SingleCategoryTag("a1", "t1", "c1");
        String inputCategory = "c1:t1";
        SingleCategoryTag.setDefaultForCategory((String)"c1", (String)"a1");
        CategoryDescription tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"c1", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)sourcedTag.getVersion());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"c1:t1(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("s1", "t1", "c2");
        inputCategory = "c2:s1/t1";
        SingleCategoryTag.setDefaultForCategory((String)"c2", (String)"s1");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"c2", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"c2:s1/t1(d)", (Object)tag.convertToString(true));
        Assert.assertEquals((Object)"s1", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a1", "t3", "c4");
        inputCategory = "c4:t3";
        SingleCategoryTag.setDefaultForCategory((String)"c4", (String)"a1");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"c4", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"c4:t3(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("s23", "t23", "cdd");
        inputCategory = "cdd:s23/t23";
        SingleCategoryTag.setDefaultForCategory((String)"cdd", (String)"s23");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"cdd", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"cdd:s23/t23(d)", (Object)tag.convertToString(true));
        Assert.assertEquals((Object)"s23", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a1", "t-64", "catA");
        inputCategory = "catA:t-64";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"a1");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:t-64(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("sss22/54", "a-d-b", "catA");
        inputCategory = "catA:sss22/54/a-d-b";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"sss22");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:sss22/54/a-d-b(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"sss22/54", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a22", "tag1", "catA");
        inputCategory = "catA:tag1";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"a22");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:tag1(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("S43", "tag1", "catA");
        inputCategory = "catA:S43/tag1";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"sS43");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)(inputCategory + "(d)"), (Object)tag.convertToString(true));
        Assert.assertEquals((Object)"S43", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("d45", "tag1", "catA");
        inputCategory = "catA:tag1(l)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"d45");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"l", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:tag1(l)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("abc/ddd/d32", "tag1", "catA");
        inputCategory = "catA:abc/ddd/d32/tag1(l)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"d2323");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"l", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)inputCategory, (Object)tag.toString());
        Assert.assertEquals((Object)"abc/ddd/d32", (Object)sourcedTag.getSource());
        SingleCategoryTag tag1 = new SingleCategoryTag("a23", "tag1", "catA");
        SingleCategoryTag tag2 = new SingleCategoryTag("a23", "tag2", "catA");
        inputCategory = "catA:tag1(123)|tag2(44)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"a23");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertEquals((long)2L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:tag1(123)|tag2(44)", (Object)tag.toString());
        tag1 = new SingleCategoryTag("b2", "tag1", "catA");
        tag2 = new SingleCategoryTag("s123", "tag2", "catA");
        inputCategory = "catA:tag1(123)|s123/tag2(44)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"b2");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertEquals((long)2L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:tag1(123)|s123/tag2(44)", (Object)tag.toString());
        Assert.assertEquals((Object)"s123", (Object)tag2.getSource());
        Assert.assertEquals((Object)"b2", (Object)tag1.getSource());
        tag1 = new SingleCategoryTag("a2", "tag1", "catA");
        tag2 = new SingleCategoryTag("a2", "tag2", "catA");
        SingleCategoryTag defaultTag = new SingleCategoryTag("a2", "t1", "catA");
        inputCategory = "catA:tag1(123)|tag2(44)|t1(d)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"a2");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertTrue((boolean)tag.containsSingleTag(defaultTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(defaultTag));
        Assert.assertEquals((long)3L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:tag1(123)|tag2(44)|t1(d)", (Object)tag.toString());
        tag1 = new SingleCategoryTag("g", "tag1", "catA");
        tag2 = new SingleCategoryTag("d", "tag2", "catA");
        defaultTag = new SingleCategoryTag("s56", "dfa", "catA");
        inputCategory = "catA:g/tag1(123)|tag2(44)|s56/dfa(d)";
        SingleCategoryTag.setDefaultForCategory((String)"catA", (String)"d");
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertTrue((boolean)tag.containsSingleTag(defaultTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(defaultTag));
        Assert.assertEquals((long)3L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:g/tag1(123)|tag2(44)|s56/dfa(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"g", (Object)tag1.getSource());
        Assert.assertEquals((Object)"d", (Object)tag2.getSource());
        Assert.assertEquals((Object)"s56", (Object)defaultTag.getSource());
        SingleCategoryTag tagA = new SingleCategoryTag("a2", "tagA", "cat0");
        SingleCategoryTag.setDefaultForCategory((String)"cat0", (String)"a2");
        inputCategory = "cat0:tagA";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"cat0", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tagA));
        Assert.assertEquals((Object)"cat0:tagA(d)", (Object)tag.toString());
        try {
            tag = CategoryDescription.parseCategoryTagInput((String)"catA:tag1(123)|tag2(44)|tag1(d)");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConfigurationDescription() throws Exception {
        String configDescriptionStr = "[acat0:s1/some-tag(d)|s5/tag1(d)*,build:s8/defaultInitial(d),catA:s9/b/atag(d)|s1/tag2(d)*,catB:s1/defaultInitial(d),timers:s8/defaultInitial(d)]";
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("acat0");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories);
        Assert.assertEquals((Object)configDescriptionStr, (Object)cd.getDescriptionName());
    }

    @Test
    public void testIllegalDescriptions() throws Exception {
        ConfigurationDescription cd;
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("acat0");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        allCategories.add("");
        String configDescriptionStr = "[acat0:s1/some-tag(d)|s5/tag1(d)*,:s8/defaultInitial(d),catA:s9/b/atag(d)|s1/tag2(d)*,catB:s1/defaultInitial(d),timers:s8/defaultInitial(d)]";
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        try {
            cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains(":s8/defaultInitial(d)"));
        }
        configDescriptionStr = "[acat0:s1/some-tag(d)|s5/(d)*,build:s8/defaultInitial(d),catA:s9/b/atag(d)|s1/tag2(d)*,catB:s1/defaultInitial(d),timers:s8/defaultInitial(d)]";
        builder = new ConfigurationInfo.Builder();
        ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        try {
            cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("s5/(d)"));
        }
    }

    @Test
    public void testConfigurationDescriptionWithSource() throws Exception {
        String configDescriptionStr = "[a1:s0/t1(d)|s1/tag1(d)*,build:s2/defaultInitial(d),catA:s6/t1(d)|s2/tag2(d)*,catB:s6/defaultInitial(d),timers:s5/defaultInitial(d)]";
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("a1");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories);
        Assert.assertEquals((Object)configDescriptionStr, (Object)cd.getDescriptionName());
    }

    @Test
    public void testInvalidEmptyTag() throws Exception {
        try {
            new SingleCategoryTag("a2", "", "cat0");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Category tag cannot be empty"));
        }
    }
}

