/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.WriterProvider;

class InMemoryWriterProvider
extends WriterProvider {
    private final Map<String, ByteArrayOutputStream> propertiesMap = new HashMap<String, ByteArrayOutputStream>();

    InMemoryWriterProvider() {
    }

    public PrintWriter getPrintWriter(String fileName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bos);
        this.propertiesMap.put(fileName, bos);
        return new PrintWriter(writer);
    }

    public InputStream getInputStream(String fileName) throws IOException {
        ByteArrayOutputStream bos = this.propertiesMap.get(fileName);
        if (bos == null) {
            return null;
        }
        byte[] array = bos.toByteArray();
        return new ByteArrayInputStream(array);
    }

    Set<String> findMatchingPropertiesFiles(String pattern) {
        Pattern p = Pattern.compile(pattern);
        return this.propertiesMap.keySet().stream().filter(p.asPredicate()).collect(Collectors.toSet());
    }

    String locateFile(String fileName) {
        return BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
    }
}

